/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.baremaps.vectortile;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.awt.*;
import java.util.List;
import java.util.Map;
import javax.swing.*;
import org.junit.jupiter.api.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public class VectorTileTest {

  private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

  @Test
  public void endToEnd() {
    var tile = new Tile(List.of(
        new Layer("layer", 256, List.of(
            new Feature(1, Map.of("a", 1.0, "b", "2"),
                GEOMETRY_FACTORY.createPoint(new Coordinate(1, 2))),
            new Feature(2, Map.of("c", 3.0, "d", "4"),
                GEOMETRY_FACTORY.createPoint(new Coordinate(2, 3)))))));

    var encoded = new VectorTileEncoder().encodeTile(tile);
    var decoded = new VectorTileDecoder().decodeTile(encoded);

    assertEquals(tile, decoded);
  }
}
