package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.Link;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("landingPage")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class LandingPage   {
  private @Valid String title;
  private @Valid String description;
  private @Valid String attribution;
  private @Valid List<Link> links = new ArrayList<>();

  /**
   * While a title is not required, implementors are strongly advised to include one.
   **/
  public LandingPage title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "While a title is not required, implementors are strongly advised to include one.")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   **/
  public LandingPage description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("description")
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * The &#x60;attribution&#x60; should be short and intended for presentation to a user, for example, in a corner of a map. Parts of the text can be links to other resources if additional information is needed. The string can include HTML markup.
   **/
  public LandingPage attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  
  @ApiModelProperty(value = "The `attribution` should be short and intended for presentation to a user, for example, in a corner of a map. Parts of the text can be links to other resources if additional information is needed. The string can include HTML markup.")
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  @JsonProperty("attribution")
  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  /**
   **/
  public LandingPage links(List<Link> links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("links")
  @NotNull
  public List<Link> getLinks() {
    return links;
  }

  @JsonProperty("links")
  public void setLinks(List<Link> links) {
    this.links = links;
  }

  public LandingPage addLinksItem(Link linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }

    this.links.add(linksItem);
    return this;
  }

  public LandingPage removeLinksItem(Link linksItem) {
    if (linksItem != null && this.links != null) {
      this.links.remove(linksItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LandingPage landingPage = (LandingPage) o;
    return Objects.equals(this.title, landingPage.title) &&
        Objects.equals(this.description, landingPage.description) &&
        Objects.equals(this.attribution, landingPage.attribution) &&
        Objects.equals(this.links, landingPage.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, description, attribution, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LandingPage {\n");
    
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

