package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.GeoJSONLineString;
import org.apache.baremaps.ogcapi.model.GeoJSONMultiLineString;
import org.apache.baremaps.ogcapi.model.GeoJSONMultiPoint;
import org.apache.baremaps.ogcapi.model.GeoJSONMultiPolygon;
import org.apache.baremaps.ogcapi.model.GeoJSONPoint;
import org.apache.baremaps.ogcapi.model.GeoJSONPolygon;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("GeoJSON_Feature_geometry")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class GeoJSONFeatureGeometry   {
  public enum TypeEnum {

    MULTIPOLYGON(String.valueOf("MultiPolygon"));


    private String value;

    TypeEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static TypeEnum fromString(String s) {
        for (TypeEnum b : TypeEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
    @JsonCreator
    public static TypeEnum fromValue(String value) {
        for (TypeEnum b : TypeEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid TypeEnum type;
  private @Valid List<List<List<List<BigDecimal>>>> coordinates = new ArrayList<>();
  private @Valid List<BigDecimal> bbox = null;

  /**
   **/
  public GeoJSONFeatureGeometry type(TypeEnum type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public TypeEnum getType() {
    return type;
  }

  @JsonProperty("type")
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   **/
  public GeoJSONFeatureGeometry coordinates(List<List<List<List<BigDecimal>>>> coordinates) {
    this.coordinates = coordinates;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("coordinates")
  @NotNull
  public List<List< @Size(min=4)List< @Size(min=2)List<BigDecimal>>>> getCoordinates() {
    return coordinates;
  }

  @JsonProperty("coordinates")
  public void setCoordinates(List<List<List<List<BigDecimal>>>> coordinates) {
    this.coordinates = coordinates;
  }

  public GeoJSONFeatureGeometry addCoordinatesItem(List<List<List<BigDecimal>>> coordinatesItem) {
    if (this.coordinates == null) {
      this.coordinates = new ArrayList<>();
    }

    this.coordinates.add(coordinatesItem);
    return this;
  }

  public GeoJSONFeatureGeometry removeCoordinatesItem(List<List<List<BigDecimal>>> coordinatesItem) {
    if (coordinatesItem != null && this.coordinates != null) {
      this.coordinates.remove(coordinatesItem);
    }

    return this;
  }
  /**
   **/
  public GeoJSONFeatureGeometry bbox(List<BigDecimal> bbox) {
    this.bbox = bbox;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("bbox")
 @Size(min=4)  public List<BigDecimal> getBbox() {
    return bbox;
  }

  @JsonProperty("bbox")
  public void setBbox(List<BigDecimal> bbox) {
    this.bbox = bbox;
  }

  public GeoJSONFeatureGeometry addBboxItem(BigDecimal bboxItem) {
    if (this.bbox == null) {
      this.bbox = new ArrayList<>();
    }

    this.bbox.add(bboxItem);
    return this;
  }

  public GeoJSONFeatureGeometry removeBboxItem(BigDecimal bboxItem) {
    if (bboxItem != null && this.bbox != null) {
      this.bbox.remove(bboxItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoJSONFeatureGeometry geoJSONFeatureGeometry = (GeoJSONFeatureGeometry) o;
    return Objects.equals(this.type, geoJSONFeatureGeometry.type) &&
        Objects.equals(this.coordinates, geoJSONFeatureGeometry.coordinates) &&
        Objects.equals(this.bbox, geoJSONFeatureGeometry.bbox);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, coordinates, bbox);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoJSONFeatureGeometry {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    coordinates: ").append(toIndentedString(coordinates)).append("\n");
    sb.append("    bbox: ").append(toIndentedString(bbox)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

