package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.baremaps.ogcapi.model.Collection;
import org.apache.baremaps.ogcapi.model.Link;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("collections")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class Collections   {
  private @Valid List<Link> links = new ArrayList<>();
  private @Valid Date timeStamp;
  private @Valid Integer numberMatched;
  private @Valid Integer numberReturned;
  private @Valid List<Collection> collections = new ArrayList<>();

  /**
   **/
  public Collections links(List<Link> links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("links")
  @NotNull
  public List<Link> getLinks() {
    return links;
  }

  @JsonProperty("links")
  public void setLinks(List<Link> links) {
    this.links = links;
  }

  public Collections addLinksItem(Link linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }

    this.links.add(linksItem);
    return this;
  }

  public Collections removeLinksItem(Link linksItem) {
    if (linksItem != null && this.links != null) {
      this.links.remove(linksItem);
    }

    return this;
  }
  /**
   **/
  public Collections timeStamp(Date timeStamp) {
    this.timeStamp = timeStamp;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("timeStamp")
  public Date getTimeStamp() {
    return timeStamp;
  }

  @JsonProperty("timeStamp")
  public void setTimeStamp(Date timeStamp) {
    this.timeStamp = timeStamp;
  }

  /**
   * minimum: 0
   **/
  public Collections numberMatched(Integer numberMatched) {
    this.numberMatched = numberMatched;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("numberMatched")
 @Min(0)  public Integer getNumberMatched() {
    return numberMatched;
  }

  @JsonProperty("numberMatched")
  public void setNumberMatched(Integer numberMatched) {
    this.numberMatched = numberMatched;
  }

  /**
   * minimum: 0
   **/
  public Collections numberReturned(Integer numberReturned) {
    this.numberReturned = numberReturned;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("numberReturned")
 @Min(0)  public Integer getNumberReturned() {
    return numberReturned;
  }

  @JsonProperty("numberReturned")
  public void setNumberReturned(Integer numberReturned) {
    this.numberReturned = numberReturned;
  }

  /**
   **/
  public Collections collections(List<Collection> collections) {
    this.collections = collections;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("collections")
  @NotNull
  public List<Collection> getCollections() {
    return collections;
  }

  @JsonProperty("collections")
  public void setCollections(List<Collection> collections) {
    this.collections = collections;
  }

  public Collections addCollectionsItem(Collection collectionsItem) {
    if (this.collections == null) {
      this.collections = new ArrayList<>();
    }

    this.collections.add(collectionsItem);
    return this;
  }

  public Collections removeCollectionsItem(Collection collectionsItem) {
    if (collectionsItem != null && this.collections != null) {
      this.collections.remove(collectionsItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Collections collections = (Collections) o;
    return Objects.equals(this.links, collections.links) &&
        Objects.equals(this.timeStamp, collections.timeStamp) &&
        Objects.equals(this.numberMatched, collections.numberMatched) &&
        Objects.equals(this.numberReturned, collections.numberReturned) &&
        Objects.equals(this.collections, collections.collections);
  }

  @Override
  public int hashCode() {
    return Objects.hash(links, timeStamp, numberMatched, numberReturned, collections);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Collections {\n");
    
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    timeStamp: ").append(toIndentedString(timeStamp)).append("\n");
    sb.append("    numberMatched: ").append(toIndentedString(numberMatched)).append("\n");
    sb.append("    numberReturned: ").append(toIndentedString(numberReturned)).append("\n");
    sb.append("    collections: ").append(toIndentedString(collections)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

