/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.raft.jraft.Lifecycle;
import org.apache.ignite3.raft.jraft.Node;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.core.Scheduler;
import org.apache.ignite3.raft.jraft.entity.NodeId;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.option.NodeOptions;
import org.apache.ignite3.raft.jraft.rpc.CoalescedHeartbeatRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.InvokeCallback;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.RpcClient;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;
import org.apache.ignite3.raft.jraft.rpc.impl.IgniteRpcClient;
import org.apache.ignite3.raft.jraft.util.OnlyForTest;

public class NodeManager
implements Lifecycle<NodeOptions> {
    private static final IgniteLogger LOG = Loggers.forClass(NodeManager.class);
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final ConcurrentMap<NodeId, Node> nodeMap = new ConcurrentHashMap<NodeId, Node>();
    private final ConcurrentMap<String, List<Node>> groupMap = new ConcurrentHashMap<String, List<Node>>();
    private final ConcurrentMap<PeerId, Queue<Object[]>> coalesced = new ConcurrentHashMap<PeerId, Queue<Object[]>>();
    private NodeOptions options;
    private Scheduler scheduler;
    private final RpcClient rpcClient;
    private RaftMessagesFactory messagesFactory;
    private BiPredicate<Message, PeerId> blockPred;

    public NodeManager(ClusterService service) {
        this.rpcClient = new IgniteRpcClient(service);
    }

    @Override
    public boolean init(NodeOptions opts) {
        this.options = opts;
        this.scheduler = opts.getScheduler();
        this.messagesFactory = opts.getRaftMessagesFactory();
        this.scheduler.schedule(this::onSentHeartbeat, opts.getElectionTimeoutMs(), TimeUnit.MILLISECONDS);
        return true;
    }

    @Override
    public void shutdown() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.rpcClient.shutdown();
    }

    public void blockMessages(BiPredicate<Message, PeerId> predicate) {
        this.blockPred = predicate;
    }

    public void stopBlock() {
        this.blockPred = null;
    }

    private void onSentHeartbeat() {
        for (PeerId remote : this.coalesced.keySet()) {
            this.coalesced.computeIfPresent(remote, (peer, queue) -> {
                if (!queue.isEmpty()) {
                    Object[] req;
                    CoalescedHeartbeatRequestBuilder builder = this.messagesFactory.coalescedHeartbeatRequest();
                    ArrayList<RpcRequests.AppendEntriesRequest> list = new ArrayList<RpcRequests.AppendEntriesRequest>();
                    builder.messages(list);
                    final ArrayList<CompletableFuture> futs = new ArrayList<CompletableFuture>();
                    ArrayList<Object[]> blocked = new ArrayList<Object[]>();
                    while ((req = (Object[])queue.poll()) != null) {
                        RpcRequests.AppendEntriesRequest msg = (RpcRequests.AppendEntriesRequest)req[0];
                        if (this.blockPred != null && this.blockPred.test(msg, (PeerId)peer)) {
                            blocked.add(req);
                            continue;
                        }
                        builder.messages().add(msg);
                        futs.add((CompletableFuture)req[1]);
                    }
                    queue.addAll(blocked);
                    try {
                        this.rpcClient.invokeAsync((PeerId)peer, builder.build(), null, new InvokeCallback(){

                            @Override
                            public void complete(Object result, Throwable err) {
                                if (err != null) {
                                    for (CompletableFuture fut : futs) {
                                        fut.completeExceptionally(err);
                                    }
                                    return;
                                }
                                RpcRequests.CoalescedHeartbeatResponse resp = (RpcRequests.CoalescedHeartbeatResponse)result;
                                assert (resp.messages().size() == futs.size());
                                int i = 0;
                                for (Message message : resp.messages()) {
                                    ((CompletableFuture)futs.get(i++)).complete(message);
                                }
                            }

                            @Override
                            public Executor executor() {
                                return NodeManager.this.options.getStripedExecutor().next();
                            }
                        }, this.options.getElectionTimeoutMs() / 2);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to send heartbeat message to remote node [remote={}].", e, peer);
                        for (CompletableFuture fut : futs) {
                            fut.completeExceptionally(e);
                        }
                    }
                }
                return queue;
            });
        }
        if (!this.stopGuard.get()) {
            this.scheduler.schedule(this::onSentHeartbeat, this.options.getElectionTimeoutMs() / 4, TimeUnit.MILLISECONDS);
        }
    }

    public boolean add(Node node) {
        NodeId nodeId = node.getNodeId();
        if (this.nodeMap.putIfAbsent(nodeId, node) == null) {
            List existsNode;
            String groupId = node.getGroupId();
            List<Node> nodes = (CopyOnWriteArrayList<Node>)this.groupMap.get(groupId);
            if (nodes == null && (existsNode = (List)this.groupMap.putIfAbsent(groupId, nodes = new CopyOnWriteArrayList<Node>())) != null) {
                nodes = existsNode;
            }
            nodes.add(node);
            return true;
        }
        return false;
    }

    @OnlyForTest
    public void clear() {
        this.groupMap.clear();
        this.nodeMap.clear();
    }

    public boolean remove(Node node) {
        if (this.nodeMap.remove(node.getNodeId(), node)) {
            PeerId peerId = node.getNodeId().getPeerId();
            for (PeerId remote : this.coalesced.keySet()) {
                if (!remote.equals(peerId.getConsistentId())) continue;
                this.coalesced.remove(remote);
            }
            List nodes = (List)this.groupMap.get(node.getGroupId());
            if (nodes != null) {
                return nodes.remove(node);
            }
        }
        return false;
    }

    public Node get(String groupId, PeerId peerId) {
        return (Node)this.nodeMap.get(new NodeId(groupId, peerId));
    }

    public List<Node> getNodesByGroupId(String groupId) {
        return (List)this.groupMap.get(groupId);
    }

    public List<Node> getAllNodes() {
        return this.groupMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public CompletableFuture<Message> enqueue(PeerId to, Message request) {
        CompletableFuture<Message> fut = new CompletableFuture<Message>();
        this.coalesced.computeIfAbsent(to, k -> new ConcurrentLinkedQueue()).add(new Object[]{request, fut});
        return fut;
    }

    public ConcurrentMap<PeerId, Queue<Object[]>> getCoalesced() {
        return this.coalesced;
    }
}

