/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.replicator;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.internal.storage.RowId;

public class PendingRows {
    private static final SortedSet<RowId> EMPTY_SET = Collections.emptySortedSet();
    private final Map<UUID, SortedSet<RowId>> txsPendingRowIds = new ConcurrentHashMap<UUID, SortedSet<RowId>>();

    public void addPendingRowId(UUID txId, RowId rowId) {
        this.txsPendingRowIds.compute(txId, (k, v) -> {
            if (v == null) {
                v = new TreeSet<RowId>();
            }
            v.add(rowId);
            return v;
        });
    }

    public void addPendingRowIds(UUID txId, Collection<RowId> rowIds) {
        this.txsPendingRowIds.compute(txId, (k, v) -> {
            if (v == null) {
                v = new TreeSet();
            }
            v.addAll(rowIds);
            return v;
        });
    }

    public Set<RowId> removePendingRowIds(UUID txId) {
        Set pendingRows = this.txsPendingRowIds.remove(txId);
        return pendingRows == null ? EMPTY_SET : pendingRows;
    }
}

