/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.replacement;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.pagememory.FullPageId;
import org.apache.ignite3.internal.pagememory.persistence.PartitionDestructionLockManager;
import org.apache.ignite3.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite3.internal.pagememory.persistence.WriteDirtyPage;
import org.apache.ignite3.internal.pagememory.persistence.replacement.DelayedDirtyPageWrite;

public class DelayedPageReplacementTracker {
    private final int pageSize;
    private final WriteDirtyPage flushDirtyPage;
    private final IgniteLogger log;
    private final Stripe[] stripes;
    private final ThreadLocal<ByteBuffer> byteBufThreadLoc;
    private final Map<Long, DelayedDirtyPageWrite> delayedPageWriteThreadLocMap = new ConcurrentHashMap<Long, DelayedDirtyPageWrite>();
    private final PartitionDestructionLockManager partitionDestructionLockManager;

    public DelayedPageReplacementTracker(int pageSize, WriteDirtyPage flushDirtyPage, IgniteLogger log, int segmentCnt, PartitionDestructionLockManager partitionDestructionLockManager) {
        this.pageSize = pageSize;
        this.flushDirtyPage = flushDirtyPage;
        this.log = log;
        this.partitionDestructionLockManager = partitionDestructionLockManager;
        this.stripes = new Stripe[segmentCnt];
        for (int i = 0; i < this.stripes.length; ++i) {
            this.stripes[i] = new Stripe();
        }
        this.byteBufThreadLoc = ThreadLocal.withInitial(() -> {
            ByteBuffer buf = ByteBuffer.allocateDirect(pageSize);
            buf.order(ByteOrder.nativeOrder());
            return buf;
        });
    }

    public DelayedDirtyPageWrite delayedPageWrite() {
        return this.delayedPageWriteThreadLocMap.computeIfAbsent(Thread.currentThread().getId(), id -> new DelayedDirtyPageWrite(this.flushDirtyPage, this.byteBufThreadLoc, this.pageSize, this, this.partitionDestructionLockManager));
    }

    private Stripe stripe(FullPageId id) {
        int segmentIdx = PersistentPageMemory.segmentIndex(id.groupId(), id.pageId(), this.stripes.length);
        return this.stripes[segmentIdx];
    }

    public void lock(FullPageId id) {
        assert (FullPageId.class == id.getClass()) : id;
        this.stripe(id).lock(id);
    }

    public void waitUnlock(FullPageId id) {
        assert (FullPageId.class == id.getClass()) : id;
        this.stripe(id).waitUnlock(id);
    }

    public void unlock(FullPageId id) {
        assert (FullPageId.class == id.getClass()) : id;
        this.stripe(id).unlock(id);
    }

    private class Stripe {
        private final Collection<FullPageId> locked = new HashSet<FullPageId>(Runtime.getRuntime().availableProcessors() * 2);
        private volatile boolean hasLockedPages;

        private Stripe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock(FullPageId id) {
            Collection<FullPageId> collection = this.locked;
            synchronized (collection) {
                this.hasLockedPages = true;
                boolean add = this.locked.add(id);
                assert (add) : "Double locking of page for replacement is not possible: " + id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUnlock(FullPageId id) {
            if (!this.hasLockedPages) {
                return;
            }
            Collection<FullPageId> collection = this.locked;
            synchronized (collection) {
                if (!this.hasLockedPages) {
                    return;
                }
                boolean interrupted = false;
                while (this.locked.contains(id)) {
                    if (DelayedPageReplacementTracker.this.log.isDebugEnabled()) {
                        DelayedPageReplacementTracker.this.log.debug("Found replaced page which is being written to page store, wait for finish replacement [id={}]", id);
                    }
                    try {
                        this.locked.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(FullPageId id) {
            Collection<FullPageId> collection = this.locked;
            synchronized (collection) {
                boolean rmv = this.locked.remove(id);
                assert (rmv) : "Unlocking page ID never locked, id: " + id;
                if (this.locked.isEmpty()) {
                    this.hasLockedPages = false;
                }
                this.locked.notifyAll();
            }
        }
    }
}

