/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.InternalTxOptions;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxPriority;
import org.apache.ignite.tx.IgniteTransactions;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionOptions;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IgniteTransactionsImpl
implements IgniteTransactions {
    private final TxManager txManager;
    private final HybridTimestampTracker observableTimestampTracker;

    public IgniteTransactionsImpl(TxManager txManager, HybridTimestampTracker observableTimestampTracker) {
        this.txManager = txManager;
        this.observableTimestampTracker = observableTimestampTracker;
    }

    public Transaction begin(@Nullable TransactionOptions options) {
        InternalTxOptions internalTxOptions = options == null ? InternalTxOptions.defaults() : InternalTxOptions.builder().timeoutMillis(options.timeoutMillis()).build();
        return this.txManager.beginExplicit(this.observableTimestampTracker, options != null && options.readOnly(), internalTxOptions);
    }

    public CompletableFuture<Transaction> beginAsync(@Nullable TransactionOptions options) {
        return CompletableFuture.completedFuture(this.begin(options));
    }

    public InternalTransaction beginImplicit(boolean readOnly) {
        return this.txManager.beginImplicit(this.observableTimestampTracker, readOnly);
    }

    @TestOnly
    public Transaction beginWithPriority(boolean readOnly, TxPriority priority) {
        return this.txManager.beginExplicit(this.observableTimestampTracker, readOnly, InternalTxOptions.defaultsWithPriority(priority));
    }
}

