/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.network.TopologyEventHandler;
import org.apache.ignite.internal.raft.server.impl.RaftServiceEventInterceptor;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.raft.jraft.NodeManager;
import org.apache.ignite.raft.jraft.RaftMessageGroup;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.RpcContext;
import org.apache.ignite.raft.jraft.rpc.RpcProcessor;
import org.apache.ignite.raft.jraft.rpc.RpcServer;
import org.apache.ignite.raft.jraft.rpc.impl.ActionRequestInterceptor;
import org.apache.ignite.raft.jraft.rpc.impl.ConnectionClosedEventListener;
import org.apache.ignite.raft.jraft.rpc.impl.InterceptingActionRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.NotifyElectProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.PingRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.RaftGroupEventsClientListener;
import org.apache.ignite.raft.jraft.rpc.impl.RaftGroupEventsProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.AddLearnersRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.AddPeerRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.ChangePeersAndLearnersAsyncRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.ChangePeersAndLearnersRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.GetLeaderRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.GetPeersRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.RemoveLearnersRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.RemovePeerRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.ResetLearnersRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.ResetPeerRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.SnapshotRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.TransferLeaderRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.AppendEntriesRequestInterceptor;
import org.apache.ignite.raft.jraft.rpc.impl.core.GetFileRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.HeartbeatRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.InstallSnapshotRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.InterceptingAppendEntriesRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.ReadIndexRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.RequestVoteRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.TimeoutNowRequestProcessor;
import org.jetbrains.annotations.Nullable;

public class IgniteRpcServer
implements RpcServer<Void> {
    private static final IgniteLogger LOG = Loggers.forClass(IgniteRpcServer.class);
    private final ClusterService service;
    private final NodeManager nodeManager;
    private final Executor rpcExecutor;
    private final List<ConnectionClosedEventListener> listeners = new CopyOnWriteArrayList<ConnectionClosedEventListener>();
    private final Map<String, RpcProcessor> processors = new ConcurrentHashMap<String, RpcProcessor>();

    public IgniteRpcServer(final ClusterService service, NodeManager nodeManager, RaftMessagesFactory raftMessagesFactory, Executor rpcExecutor, final RaftServiceEventInterceptor serviceEventInterceptor, RaftGroupEventsClientListener raftGroupEventsClientListener, AppendEntriesRequestInterceptor appendEntriesRequestFilter, ActionRequestInterceptor actionRequestInterceptor) {
        this.service = service;
        this.nodeManager = nodeManager;
        this.rpcExecutor = rpcExecutor;
        InterceptingAppendEntriesRequestProcessor appendEntriesRequestProcessor = new InterceptingAppendEntriesRequestProcessor(rpcExecutor, raftMessagesFactory, appendEntriesRequestFilter);
        this.registerConnectionClosedEventListener(appendEntriesRequestProcessor);
        this.registerProcessor(appendEntriesRequestProcessor);
        this.registerProcessor(new GetFileRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new InstallSnapshotRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new RequestVoteRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new PingRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new TimeoutNowRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ReadIndexRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new HeartbeatRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new GetLeaderRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new AddPeerRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new RemovePeerRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ResetPeerRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ChangePeersAndLearnersRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ChangePeersAndLearnersAsyncRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new SnapshotRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new TransferLeaderRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new GetPeersRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new AddLearnersRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new RemoveLearnersRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ResetLearnersRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new InterceptingActionRequestProcessor(rpcExecutor, raftMessagesFactory, actionRequestInterceptor));
        this.registerProcessor(new NotifyElectProcessor(raftMessagesFactory, serviceEventInterceptor));
        this.registerProcessor(new RaftGroupEventsProcessor(raftGroupEventsClientListener));
        RpcMessageHandler messageHandler = new RpcMessageHandler();
        service.messagingService().addMessageHandler(RaftMessageGroup.class, (NetworkMessageHandler)messageHandler);
        service.topologyService().addEventHandler(new TopologyEventHandler(){

            public void onAppeared(InternalClusterNode member) {
            }

            public void onDisappeared(InternalClusterNode member) {
                serviceEventInterceptor.unsubscribeNode(member);
                for (ConnectionClosedEventListener listener : IgniteRpcServer.this.listeners) {
                    listener.onClosed(service.topologyService().localMember().name(), member.name());
                }
            }
        });
    }

    @Override
    public void registerConnectionClosedEventListener(ConnectionClosedEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void registerProcessor(RpcProcessor<?> processor) {
        this.processors.put(processor.interest(), processor);
    }

    @Override
    public int boundPort() {
        return 0;
    }

    @Override
    public String consistentId() {
        return this.service.topologyService().localMember().name();
    }

    @Override
    public boolean init(Void opts) {
        return true;
    }

    public ClusterService clusterService() {
        return this.service;
    }

    @Override
    public void shutdown() {
    }

    public class RpcMessageHandler
    implements NetworkMessageHandler {
        public void onReceived(NetworkMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
            Class cls = message.getClass();
            RpcProcessor<NetworkMessage> prc = this.getProcessor(cls, cls);
            if (prc == null) {
                return;
            }
            RpcProcessor.ExecutorSelector selector = prc.executorSelector();
            Executor executor = selector != null ? selector.select(prc.getClass().getName(), message, IgniteRpcServer.this.nodeManager) : (prc.executor() != null ? prc.executor() : IgniteRpcServer.this.rpcExecutor);
            RpcProcessor<NetworkMessage> finalPrc = prc;
            try {
                if (IgniteUtils.shouldSwitchToRequestsExecutor((ThreadOperation[])new ThreadOperation[]{ThreadOperation.PROCESS_RAFT_REQ})) {
                    executor.execute(() -> finalPrc.handleRequest(new NetworkRpcContext(executor, sender, correlationId), message));
                } else {
                    finalPrc.handleRequest(new NetworkRpcContext(executor, sender, correlationId), message);
                }
            }
            catch (RejectedExecutionException e) {
                LOG.warn("A request execution was rejected [sender={} req={} reason={}]", new Object[]{sender, S.toString((Object)message), e.getMessage()});
            }
        }

        @Nullable
        private RpcProcessor<NetworkMessage> getProcessor(Class<?> origin, Class<?> cls) {
            RpcProcessor<NetworkMessage> prc = IgniteRpcServer.this.processors.get(cls.getName());
            if (prc != null) {
                return prc;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                prc = this.getProcessor(origin, iface);
                if (prc == null) continue;
                IgniteRpcServer.this.processors.putIfAbsent(origin.getName(), prc);
                return prc;
            }
            return null;
        }
    }

    private class NetworkRpcContext
    implements RpcContext {
        private final InternalClusterNode sender;
        private final Long correlationId;
        private final Executor executor;

        public NetworkRpcContext(Executor executor, InternalClusterNode sender, Long correlationId) {
            this.executor = executor;
            this.sender = sender;
            this.correlationId = correlationId;
        }

        @Override
        public NodeManager getNodeManager() {
            return IgniteRpcServer.this.nodeManager;
        }

        @Override
        public void sendResponse(Object responseObj) {
            IgniteRpcServer.this.service.messagingService().respond(this.sender, (NetworkMessage)responseObj, this.correlationId.longValue());
        }

        @Override
        public void sendResponseAsync(Object responseObj) {
            this.executor.execute(() -> IgniteRpcServer.this.service.messagingService().send(this.sender, (NetworkMessage)responseObj));
        }

        @Override
        public NetworkAddress getRemoteAddress() {
            return this.sender.address();
        }

        @Override
        public InternalClusterNode getSender() {
            return this.sender;
        }

        @Override
        public String getLocalConsistentId() {
            return IgniteRpcServer.this.service.topologyService().localMember().name();
        }
    }
}

