/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.impl;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.impl.CursorSubscription;
import org.apache.ignite.internal.metastorage.impl.MetaStorageServiceContext;
import org.apache.ignite.internal.raft.ReadCommand;

class CursorPublisher
implements Flow.Publisher<Entry> {
    private final MetaStorageServiceContext context;
    private final Function<byte[], ReadCommand> nextBatchCommandSupplier;
    private final AtomicBoolean subscriptionGuard = new AtomicBoolean();

    CursorPublisher(MetaStorageServiceContext context, Function<byte[], ReadCommand> nextBatchCommandSupplier) {
        this.context = context;
        this.nextBatchCommandSupplier = nextBatchCommandSupplier;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Entry> subscriber) {
        if (!this.subscriptionGuard.compareAndSet(false, true)) {
            throw new IllegalArgumentException("This publisher supports only one subscriber");
        }
        if (!this.context.busyLock().enterBusy()) {
            subscriber.onError(new NodeStoppingException());
            return;
        }
        try {
            CursorSubscription subscription = new CursorSubscription(this.context, this.nextBatchCommandSupplier, subscriber);
            subscriber.onSubscribe(subscription);
        }
        finally {
            this.context.busyLock().leaveBusy();
        }
    }
}

