/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ignite.internal.compute.loader.JobContext;
import org.apache.ignite.internal.deployunit.exception.DeploymentUnitNotFoundException;
import org.apache.ignite.internal.deployunit.exception.DeploymentUnitUnavailableException;

class ClassLoaderExceptionsMapper {
    private static final String DEPLOYMENT_UNIT_DOES_NOT_EXIST_MSG = "%s. Deployment unit %s:%s doesn't exist";
    private static final String DEPLOYMENT_UNIT_NOT_AVAILABLE_MSG = "%s. Deployment unit %s:%s can't be used: [clusterStatus = %s, nodeStatus = %s]";

    ClassLoaderExceptionsMapper() {
    }

    static CompletableFuture<JobContext> mapClassLoaderExceptions(CompletableFuture<JobContext> future, String jobClassName) {
        return future.handle((v, e) -> {
            if (e instanceof Exception) {
                throw new CompletionException(ClassLoaderExceptionsMapper.mapException(ClassLoaderExceptionsMapper.unwrapCompletionException((Exception)e), jobClassName));
            }
            return v;
        });
    }

    private static Exception mapException(Exception e, String jobClassName) {
        if (e instanceof DeploymentUnitNotFoundException) {
            return new ClassNotFoundException(String.format(DEPLOYMENT_UNIT_DOES_NOT_EXIST_MSG, jobClassName, ((DeploymentUnitNotFoundException)e).id(), ((DeploymentUnitNotFoundException)e).version()));
        }
        if (e instanceof DeploymentUnitUnavailableException) {
            return new ClassNotFoundException(String.format(DEPLOYMENT_UNIT_NOT_AVAILABLE_MSG, jobClassName, ((DeploymentUnitUnavailableException)e).id(), ((DeploymentUnitUnavailableException)e).version(), ((DeploymentUnitUnavailableException)e).clusterStatus(), ((DeploymentUnitUnavailableException)e).nodeStatus()));
        }
        return e;
    }

    private static Exception unwrapCompletionException(Exception exception) {
        if (exception instanceof CompletionException) {
            return (Exception)exception.getCause();
        }
        return exception;
    }
}

