/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence;

import org.apache.ignite.internal.metrics.IntGauge;
import org.apache.ignite.internal.metrics.LongAdderMetric;
import org.apache.ignite.internal.metrics.LongGauge;
import org.apache.ignite.internal.pagememory.configuration.PersistentDataRegionConfiguration;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemoryMetricSource;

class PersistentPageMemoryMetrics {
    private final LongAdderMetric readPagesFromDisk;
    private final LongAdderMetric writePagesToDisk;

    PersistentPageMemoryMetrics(PersistentPageMemoryMetricSource source, PersistentPageMemory pageMemory, PersistentDataRegionConfiguration dataRegionConfiguration) {
        source.addMetric(new IntGauge("UsedCheckpointBufferPages", "Number of currently used pages in checkpoint buffer.", pageMemory::usedCheckpointBufferPages));
        source.addMetric(new IntGauge("MaxCheckpointBufferPages", "The capacity of checkpoint buffer in pages.", pageMemory::maxCheckpointBufferPages));
        source.addMetric(new LongGauge("MaxSize", "Maximum in-memory region size in bytes.", dataRegionConfiguration::sizeBytes));
        this.readPagesFromDisk = source.addMetric(new LongAdderMetric("PagesRead", "Number of pages read from disk since the last restart."));
        this.writePagesToDisk = source.addMetric(new LongAdderMetric("PagesWritten", "Number of pages written to disk since the last restart."));
    }

    public void incrementReadFromDiskMetric() {
        this.readPagesFromDisk.increment();
    }

    public void incrementWriteToDiskMetric() {
        this.writePagesToDisk.increment();
    }
}

