/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.transaction;

import io.micronaut.http.annotation.Controller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.transaction.TransactionApi;
import org.apache.ignite.internal.rest.api.transaction.TransactionInfo;
import org.apache.ignite.internal.rest.transaction.exception.TransactionKillException;
import org.apache.ignite.internal.rest.transaction.exception.TransactionNotFoundException;
import org.apache.ignite.internal.sql.engine.api.kill.CancellableOperationType;
import org.apache.ignite.internal.sql.engine.api.kill.KillHandlerRegistry;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.jetbrains.annotations.Nullable;

@Controller(value="/management/v1/transaction")
public class TransactionController
implements TransactionApi,
ResourceHolder {
    private static final IgniteLogger LOG = Loggers.forClass(TransactionController.class);
    private IgniteSql igniteSql;
    private KillHandlerRegistry killHandlerRegistry;

    public TransactionController(IgniteSql igniteSql, KillHandlerRegistry killHandlerRegistry) {
        this.igniteSql = igniteSql;
        this.killHandlerRegistry = killHandlerRegistry;
    }

    public CompletableFuture<Collection<TransactionInfo>> transactions() {
        return this.transactionInfos();
    }

    public CompletableFuture<TransactionInfo> transaction(UUID transactionId) {
        return this.transactionInfos(transactionId).thenApply(transactionInfos -> {
            Iterator iterator = transactionInfos.iterator();
            if (iterator.hasNext()) {
                return (TransactionInfo)iterator.next();
            }
            throw new TransactionNotFoundException(transactionId.toString());
        });
    }

    public CompletableFuture<Void> killTransaction(UUID transactionId) {
        try {
            return this.killHandlerRegistry.handler(CancellableOperationType.TRANSACTION).cancelAsync(transactionId.toString()).thenApply(result -> TransactionController.handleOperationResult(transactionId, result));
        }
        catch (Exception e) {
            LOG.error("Transaction {} can't be killed.", new Object[]{transactionId, e});
            return CompletableFuture.failedFuture((Throwable)((Object)new TransactionKillException(transactionId.toString())));
        }
    }

    private static Void handleOperationResult(UUID transactionId, @Nullable Boolean result) {
        if (result != null && !result.booleanValue()) {
            throw new TransactionNotFoundException(transactionId.toString());
        }
        return null;
    }

    public void cleanResources() {
        this.igniteSql = null;
        this.killHandlerRegistry = null;
    }

    private CompletableFuture<Collection<TransactionInfo>> transactionInfos() {
        return this.transactionInfos("SELECT * FROM SYSTEM.TRANSACTIONS ORDER BY START_TIME");
    }

    private CompletableFuture<Collection<TransactionInfo>> transactionInfos(UUID transactionId) {
        return this.transactionInfos("SELECT * FROM SYSTEM.TRANSACTIONS WHERE ID='" + transactionId.toString() + "'");
    }

    private CompletableFuture<Collection<TransactionInfo>> transactionInfos(String query) {
        Statement transactionStmt = this.igniteSql.createStatement(query);
        return this.igniteSql.executeAsync(null, transactionStmt, new Object[0]).thenCompose(resultSet -> TransactionController.iterate((AsyncResultSet<SqlRow>)resultSet, new ArrayList<TransactionInfo>()));
    }

    private static CompletableFuture<Collection<TransactionInfo>> iterate(AsyncResultSet<SqlRow> resultSet, List<TransactionInfo> result) {
        for (SqlRow row : resultSet.currentPage()) {
            result.add(TransactionController.convert(row));
        }
        if (resultSet.hasMorePages()) {
            return resultSet.fetchNextPage().thenCompose(nextPage -> TransactionController.iterate((AsyncResultSet<SqlRow>)nextPage, result));
        }
        return CompletableFuture.completedFuture(result);
    }

    private static TransactionInfo convert(SqlRow row) {
        return new TransactionInfo(UUID.fromString(row.stringValue("ID")), row.stringValue("COORDINATOR_NODE_ID"), row.stringValue("STATE"), row.stringValue("TYPE"), row.stringValue("PRIORITY"), row.timestampValue("START_TIME"));
    }
}

