/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util.concurrent;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class LongHeldDetectingReadWriteLock
implements ReadWriteLock {
    private final Lock rLock;
    private final Lock wLock;

    public LongHeldDetectingReadWriteLock(long maxBlockingTimeToReport, TimeUnit unit) {
        this(false, maxBlockingTimeToReport, unit);
    }

    public LongHeldDetectingReadWriteLock(boolean fair, long maxBlockingTimeToReport, TimeUnit unit) {
        RwLock rwLock = new RwLock(fair);
        long maxBlockingNanos = unit.toNanos(maxBlockingTimeToReport);
        if (maxBlockingNanos > 0L) {
            this.rLock = new LongHeldDetectingLock(AcquireMode.Read, rwLock, maxBlockingNanos);
            this.wLock = new LongHeldDetectingLock(AcquireMode.Write, rwLock, maxBlockingNanos);
        } else {
            this.rLock = rwLock.readLock();
            this.wLock = rwLock.writeLock();
        }
    }

    @Override
    public Lock readLock() {
        return this.rLock;
    }

    @Override
    public Lock writeLock() {
        return this.wLock;
    }

    public abstract void report(AcquireMode var1, Thread var2, Collection<Thread> var3, long var4);

    static class RwLock
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = -1783358548846940445L;

        RwLock(boolean fair) {
            super(fair);
        }

        @Override
        public Thread getOwner() {
            return super.getOwner();
        }

        @Override
        public Collection<Thread> getQueuedThreads() {
            return super.getQueuedThreads();
        }
    }

    class LongHeldDetectingLock
    implements Lock {
        private final AcquireMode mode;
        private final RwLock parent;
        private final Lock delegate;
        private final long maxBlockingNanos;

        LongHeldDetectingLock(AcquireMode mode, RwLock parent, long maxBlockingNanos) {
            this.mode = mode;
            this.parent = parent;
            this.delegate = mode == AcquireMode.Read ? parent.readLock() : parent.writeLock();
            this.maxBlockingNanos = maxBlockingNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            long start = System.nanoTime();
            Thread owner = this.parent.getOwner();
            try {
                this.delegate.lock();
            }
            finally {
                long elapsed = System.nanoTime() - start;
                if (elapsed > this.maxBlockingNanos) {
                    LongHeldDetectingReadWriteLock.this.report(this.mode, owner, this.parent.getQueuedThreads(), elapsed);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lockInterruptibly() throws InterruptedException {
            long start = System.nanoTime();
            Thread owner = this.parent.getOwner();
            try {
                this.delegate.lockInterruptibly();
            }
            finally {
                long elapsed = System.nanoTime() - start;
                if (elapsed > this.maxBlockingNanos) {
                    LongHeldDetectingReadWriteLock.this.report(this.mode, owner, this.parent.getQueuedThreads(), elapsed);
                }
            }
        }

        @Override
        public boolean tryLock() {
            return this.delegate.tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.delegate.tryLock(time, unit);
        }

        @Override
        public void unlock() {
            this.delegate.unlock();
        }

        @Override
        public Condition newCondition() {
            return this.delegate.newCondition();
        }
    }

    public static enum AcquireMode {
        Read,
        Write;

    }
}

