/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.ExplicitOperandTypeInference;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;

public abstract class InferTypes {
    public static final SqlOperandTypeInference FIRST_KNOWN = (callBinding, returnType, operandTypes) -> {
        SqlNode operand;
        RelDataType unknownType;
        RelDataType knownType = unknownType = callBinding.getValidator().getUnknownType();
        Iterator<SqlNode> iterator = callBinding.operands().iterator();
        while (iterator.hasNext() && (knownType = SqlTypeUtil.deriveType(callBinding, operand = iterator.next())).equals(unknownType)) {
        }
        Arrays.fill(operandTypes, knownType);
    };
    public static final SqlOperandTypeInference RETURN_TYPE = (callBinding, returnType, operandTypes) -> {
        for (int i = 0; i < operandTypes.length; ++i) {
            operandTypes[i] = returnType.isStruct() ? returnType.getFieldList().get(i).getType() : returnType;
        }
    };
    public static final SqlOperandTypeInference BOOLEAN = (callBinding, returnType, operandTypes) -> {
        RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
        for (int i = 0; i < operandTypes.length; ++i) {
            operandTypes[i] = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }
    };
    public static final SqlOperandTypeInference VARCHAR_1024 = (callBinding, returnType, operandTypes) -> {
        RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
        for (int i = 0; i < operandTypes.length; ++i) {
            operandTypes[i] = typeFactory.createSqlType(SqlTypeName.VARCHAR, 1024);
        }
    };
    public static final SqlOperandTypeInference ANY_NULLABLE = (callBinding, returnType, operandTypes) -> {
        RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
        for (int i = 0; i < operandTypes.length; ++i) {
            operandTypes[i] = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
    };

    private InferTypes() {
    }

    public static SqlOperandTypeInference explicit(List<RelDataType> types) {
        return new ExplicitOperandTypeInference((ImmutableList<RelDataType>)ImmutableList.copyOf(types));
    }
}

