/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.ignite.internal.network.NodeFinder;
import org.apache.ignite.internal.network.StaticNodeFinder;
import org.apache.ignite.internal.network.configuration.NodeFinderType;
import org.apache.ignite.internal.network.configuration.NodeFinderView;
import org.apache.ignite.network.NetworkAddress;

public class NodeFinderFactory {
    public static NodeFinder createNodeFinder(NodeFinderView nodeFinderConfiguration) {
        NodeFinderType type;
        String typeString = nodeFinderConfiguration.type();
        try {
            type = NodeFinderType.valueOf(typeString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to create NodeFinder " + typeString, e);
        }
        switch (type) {
            case STATIC: {
                return Arrays.stream(nodeFinderConfiguration.netClusterNodes()).map(NetworkAddress::from).collect(Collectors.collectingAndThen(Collectors.toUnmodifiableList(), StaticNodeFinder::new));
            }
        }
        throw new IllegalArgumentException("Unsupported NodeFinder type " + String.valueOf((Object)type));
    }
}

