/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.ignite.internal.replicator.PartitionGroupId;

public class TablePartitionId
implements PartitionGroupId {
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("_part_");
    private final int tableId;
    private final int partId;

    public TablePartitionId(int tableId, int partId) {
        this.tableId = tableId;
        this.partId = partId;
    }

    public static TablePartitionId fromString(String str) {
        String[] parts = DELIMITER_PATTERN.split(str);
        return new TablePartitionId(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    @Override
    public int objectId() {
        return this.tableId;
    }

    @Override
    public int partitionId() {
        return this.partId;
    }

    public int tableId() {
        return this.tableId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TablePartitionId that = (TablePartitionId)o;
        return this.partId == that.partId && this.tableId == that.tableId;
    }

    public int hashCode() {
        return Objects.hash(this.partId, this.tableId);
    }

    public String toString() {
        return this.tableId + "_part_" + this.partId;
    }
}

