/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.query.calcite.message.MarshalableMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationMappingException;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.GridIntIterator;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class ColocationGroup
implements MarshalableMessage {
    private long[] sourceIds;
    @GridDirectCollection(value=UUID.class)
    private List<UUID> nodeIds;
    @GridDirectTransient
    private List<List<UUID>> assignments;
    private int[] marshalledAssignments;

    public static ColocationGroup forNodes(List<UUID> nodeIds) {
        return new ColocationGroup(null, nodeIds, null);
    }

    public static ColocationGroup forAssignments(List<List<UUID>> assignments) {
        return new ColocationGroup(null, null, assignments);
    }

    public static ColocationGroup forSourceId(long sourceId) {
        return new ColocationGroup(new long[]{sourceId}, null, null);
    }

    public ColocationGroup local(UUID nodeId) {
        List<List<UUID>> locAssignments = null;
        if (this.assignments != null) {
            locAssignments = this.assignments.stream().map(l -> nodeId.equals(l.get(0)) ? l : Collections.emptyList()).collect(Collectors.toList());
        }
        return new ColocationGroup(Arrays.copyOf(this.sourceIds, this.sourceIds.length), Collections.singletonList(nodeId), locAssignments);
    }

    public ColocationGroup() {
    }

    private ColocationGroup(long[] sourceIds, List<UUID> nodeIds, List<List<UUID>> assignments) {
        this.sourceIds = sourceIds;
        this.nodeIds = nodeIds;
        this.assignments = assignments;
    }

    public List<UUID> nodeIds() {
        return this.nodeIds == null ? Collections.emptyList() : this.nodeIds;
    }

    public List<List<UUID>> assignments() {
        if (this.assignments != null) {
            return this.assignments;
        }
        if (!F.isEmpty(this.nodeIds)) {
            return this.nodeIds.stream().map(Collections::singletonList).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean belongs(long sourceId) {
        if (this.sourceIds == null) {
            return false;
        }
        for (long i : this.sourceIds) {
            if (i != sourceId) continue;
            return true;
        }
        return false;
    }

    public ColocationGroup colocate(ColocationGroup other) throws ColocationMappingException {
        List<List<UUID>> assignments;
        long[] srcIds = this.sourceIds == null || other.sourceIds == null ? (long[])U.firstNotNull((Object[])new long[][]{this.sourceIds, other.sourceIds}) : LongStream.concat(Arrays.stream(this.sourceIds), Arrays.stream(other.sourceIds)).distinct().toArray();
        List nodeIds = this.nodeIds == null || other.nodeIds == null ? (List)U.firstNotNull((Object[])new List[]{this.nodeIds, other.nodeIds}) : Commons.intersect(other.nodeIds, this.nodeIds);
        if (nodeIds != null && nodeIds.isEmpty()) {
            throw new ColocationMappingException("Failed to map fragment to location. Replicated query parts are not co-located on all nodes");
        }
        if (this.assignments == null || other.assignments == null) {
            assignments = (List)U.firstNotNull((Object[])new List[]{this.assignments, other.assignments});
            if (assignments != null && nodeIds != null) {
                HashSet filter = new HashSet(nodeIds);
                ArrayList assignments0 = new ArrayList(assignments.size());
                for (int i = 0; i < assignments.size(); ++i) {
                    List assignment = Commons.intersect(filter, (List)assignments.get(i));
                    if (assignment.isEmpty()) {
                        throw new ColocationMappingException("Failed to map fragment to location. Partition mapping is empty [part=" + i + "]");
                    }
                    assignments0.add(assignment);
                }
                assignments = assignments0;
            }
        } else {
            assert (this.assignments.size() == other.assignments.size());
            assignments = new ArrayList(this.assignments.size());
            HashSet filter = nodeIds == null ? null : new HashSet(nodeIds);
            for (int i = 0; i < this.assignments.size(); ++i) {
                List<UUID> assignment = Commons.intersect(this.assignments.get(i), other.assignments.get(i));
                if (filter != null) {
                    assignment.retainAll(filter);
                }
                if (assignment.isEmpty()) {
                    throw new ColocationMappingException("Failed to map fragment to location. Partition mapping is empty [part=" + i + "]");
                }
                assignments.add(assignment);
            }
        }
        return new ColocationGroup(srcIds, nodeIds, assignments);
    }

    public ColocationGroup finalizeMapping() {
        if (this.assignments == null) {
            return this;
        }
        ArrayList<List<UUID>> assignments = new ArrayList<List<UUID>>(this.assignments.size());
        HashSet<UUID> nodes = new HashSet<UUID>();
        for (List<UUID> assignment : this.assignments) {
            UUID first = (UUID)F.first(assignment);
            if (first != null) {
                nodes.add(first);
            }
            assignments.add(first != null ? Collections.singletonList(first) : Collections.emptyList());
        }
        return new ColocationGroup(this.sourceIds, new ArrayList<UUID>(nodes), assignments);
    }

    public ColocationGroup filterByPartitions(int[] parts) {
        if (!F.isEmpty(this.assignments)) {
            ArrayList<List<UUID>> assignments = new ArrayList<List<UUID>>(this.assignments.size());
            HashSet<UUID> nodes = new HashSet<UUID>();
            if (parts == null) {
                return this;
            }
            if (parts.length > 0) {
                for (int i = 0; i < this.assignments.size(); ++i) {
                    UUID first;
                    UUID uUID = first = Arrays.binarySearch(parts, i) >= 0 ? (UUID)F.first(this.assignments.get(i)) : null;
                    if (first != null) {
                        nodes.add(first);
                    }
                    assignments.add(first != null ? this.assignments.get(i) : Collections.emptyList());
                }
            } else {
                for (int i = 0; i < this.assignments.size(); ++i) {
                    assignments.add(Collections.emptyList());
                }
            }
            return new ColocationGroup(this.sourceIds, new ArrayList<UUID>(nodes), assignments);
        }
        return this;
    }

    public ColocationGroup mapToNodes(List<UUID> nodeIds) {
        return !F.isEmpty(this.nodeIds) ? this : new ColocationGroup(this.sourceIds, nodeIds, null);
    }

    public int[] partitions(UUID nodeId) {
        if (F.isEmpty(this.assignments)) {
            return null;
        }
        GridIntList parts = new GridIntList(this.assignments.size());
        for (int i = 0; i < this.assignments.size(); ++i) {
            List<UUID> assignment = this.assignments.get(i);
            if (!Objects.equals(nodeId, F.first(assignment))) continue;
            parts.add(i);
        }
        return parts.array();
    }

    @Override
    public MessageType type() {
        return MessageType.COLOCATION_GROUP;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeIntArray("marshalledAssignments", this.marshalledAssignments)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeCollection("nodeIds", this.nodeIds, MessageCollectionItemType.UUID)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLongArray("sourceIds", this.sourceIds)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.marshalledAssignments = reader.readIntArray("marshalledAssignments");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.nodeIds = (List)reader.readCollection("nodeIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.sourceIds = reader.readLongArray("sourceIds");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ColocationGroup.class);
    }

    public byte fieldsCount() {
        return 3;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext<?, ?> ctx) {
        if (this.assignments != null && this.marshalledAssignments == null) {
            HashMap<UUID, Integer> nodeIdxs = new HashMap<UUID, Integer>();
            for (int i = 0; i < this.nodeIds.size(); ++i) {
                nodeIdxs.put(this.nodeIds.get(i), i);
            }
            int bitsPerPart = 32 - Integer.numberOfLeadingZeros(this.nodeIds.size());
            CompactedIntArray.Builder builder = CompactedIntArray.builder(bitsPerPart, this.assignments.size());
            for (List<UUID> assignment : this.assignments) {
                assert (F.isEmpty(assignment) || assignment.size() == 1);
                if (F.isEmpty(assignment)) {
                    builder.add(this.nodeIds.size());
                    continue;
                }
                Integer nodeIdx = (Integer)nodeIdxs.get(assignment.get(0));
                builder.add(nodeIdx);
            }
            this.marshalledAssignments = builder.build().buffer();
        }
    }

    @Override
    public void prepareUnmarshal(GridCacheSharedContext<?, ?> ctx) {
        if (this.marshalledAssignments != null && this.assignments == null) {
            int bitsPerPart = 32 - Integer.numberOfLeadingZeros(this.nodeIds.size());
            CompactedIntArray compactedArr = CompactedIntArray.of(bitsPerPart, this.marshalledAssignments);
            this.assignments = new ArrayList<List<UUID>>(compactedArr.size());
            GridIntIterator iter = compactedArr.iterator();
            while (iter.hasNext()) {
                int nodeIdx = iter.next();
                this.assignments.add(nodeIdx >= this.nodeIds.size() ? Collections.emptyList() : Collections.singletonList(this.nodeIds.get(nodeIdx)));
            }
        }
    }

    private static class CompactedIntArray {
        protected static final int BUF_POS_MASK = 31;
        protected static final int BUF_POS_LOG2 = 32 - Integer.numberOfLeadingZeros(31);
        protected static final int[] BIT_MASKS = new int[32];
        private final int[] buf;
        private final int bitsPerItem;

        private CompactedIntArray(int bitsPerItem, int[] buf) {
            this.bitsPerItem = bitsPerItem;
            this.buf = buf;
        }

        public int[] buffer() {
            return this.buf;
        }

        public int size() {
            return this.buf[0];
        }

        public GridIntIterator iterator() {
            return new Iterator();
        }

        public static CompactedIntArray of(int bitsPerItem, int[] buf) {
            return new CompactedIntArray(bitsPerItem, buf);
        }

        public static Builder builder(int bitsPerItem, int capacity) {
            return new Builder(bitsPerItem, capacity);
        }

        static {
            for (int i = 0; i < 32; ++i) {
                CompactedIntArray.BIT_MASKS[i] = ~(-1 << i);
            }
        }

        private class Iterator
        implements GridIntIterator {
            private int bitPos = 32;
            private int pos;
            private final int size;

            private Iterator() {
                this.size = CompactedIntArray.this.buf[0];
            }

            public boolean hasNext() {
                return this.pos < this.size;
            }

            public int next() {
                assert (this.pos < this.size);
                int bitPos = this.bitPos;
                int bitsFirstBuf = Math.min(CompactedIntArray.this.bitsPerItem, 32 - (bitPos & 0x1F));
                int val = CompactedIntArray.this.buf[bitPos >> BUF_POS_LOG2] >> (bitPos & 0x1F) & BIT_MASKS[bitsFirstBuf];
                bitPos += bitsFirstBuf;
                if (bitsFirstBuf < CompactedIntArray.this.bitsPerItem) {
                    int bitsSecondBuf = CompactedIntArray.this.bitsPerItem - bitsFirstBuf;
                    val |= (CompactedIntArray.this.buf[bitPos >> BUF_POS_LOG2] >> (bitPos & 0x1F) & BIT_MASKS[bitsSecondBuf]) << bitsFirstBuf;
                    bitPos += bitsSecondBuf;
                }
                this.bitPos = bitPos;
                ++this.pos;
                return val;
            }
        }

        private static class Builder {
            private int bitPos = 32;
            private int size;
            protected final int[] buf;
            protected final int bitsPerItem;

            public Builder(int bitsPerItem, int capacity) {
                this.bitsPerItem = bitsPerItem;
                this.buf = new int[(capacity * bitsPerItem + 32 - 1) / 32 + 1];
                this.buf[0] = capacity;
            }

            public void add(int val) {
                int bitsToWriteCurBuf;
                assert (this.size < this.buf[0]);
                int bitsToWrite = this.bitsPerItem;
                int bitPos = this.bitPos;
                do {
                    bitsToWriteCurBuf = Math.min(bitsToWrite, 32 - (bitPos & 0x1F));
                    int writeVal = (val & BIT_MASKS[bitsToWriteCurBuf]) << (bitPos & 0x1F);
                    val >>= bitsToWriteCurBuf;
                    int n = bitPos >> BUF_POS_LOG2;
                    this.buf[n] = this.buf[n] | writeVal;
                    bitPos += bitsToWriteCurBuf;
                } while ((bitsToWrite -= bitsToWriteCurBuf) > 0);
                this.bitPos = bitPos;
                ++this.size;
            }

            public CompactedIntArray build() {
                this.buf[0] = this.size;
                return new CompactedIntArray(this.bitsPerItem, this.buf);
            }
        }
    }
}

