/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management;

import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.thin.ClientClusterImpl;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.management.SetStateCommandArg;
import org.apache.ignite.internal.management.api.LocalCommand;
import org.jetbrains.annotations.Nullable;

public class SetStateCommand
implements LocalCommand<SetStateCommandArg, Boolean> {
    @Override
    public String description() {
        return "Change cluster state";
    }

    @Override
    public Class<SetStateCommandArg> argClass() {
        return SetStateCommandArg.class;
    }

    @Override
    public Boolean execute(@Nullable GridClient cli, @Nullable IgniteClient client, @Nullable Ignite ignite, SetStateCommandArg arg, Consumer<String> printer) throws GridClientException {
        ClusterState clusterState;
        ClusterState clusterState2 = cli != null ? cli.state().state() : (clusterState = client != null ? client.cluster().state() : ignite.cluster().state());
        if (clusterState == arg.state()) {
            printer.accept("Cluster state is already " + arg.state() + ".");
            return false;
        }
        if (cli != null) {
            cli.state().state(arg.state(), arg.force());
        } else if (ignite != null) {
            ((IgniteClusterEx)ignite.cluster()).state(arg.state(), arg.force());
        } else {
            ((ClientClusterImpl)client.cluster()).state(arg.state(), arg.force());
        }
        printer.accept("Cluster state changed to " + arg.state() + ".");
        return true;
    }

    @Override
    public String confirmationPrompt(SetStateCommandArg arg) {
        return "Warning: the command will change state of cluster with name \"" + arg.clusterName() + "\" to " + arg.state() + ".";
    }
}

