/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.upload;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.ignite.yardstick.jdbc.AbstractJdbcBenchmark;
import org.apache.ignite.yardstick.upload.model.QueryFactory;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class AbstractUploadBenchmark
extends AbstractJdbcBenchmark {
    long insertRowsCnt;
    long warmupRowsCnt;
    protected QueryFactory queries;

    @Override
    public final void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.insertRowsCnt = this.args.upload.uploadRowsCnt();
        this.warmupRowsCnt = this.args.upload.warmupRowsCnt();
        this.init();
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"Starting custom warmup");
        if (this.args.upload.disableWal()) {
            this.executeUpdate("ALTER TABLE test_upload NOLOGGING");
        }
        try (Connection warmupConn = this.uploadConnection();){
            if (this.args.upload.useStreaming()) {
                AbstractUploadBenchmark.executeUpdateOn(warmupConn, this.queries.turnOnStreaming(this.args.upload));
            }
            this.warmup(warmupConn);
            if (this.args.upload.useStreaming()) {
                AbstractUploadBenchmark.executeUpdateOn(warmupConn, "SET STREAMING OFF");
            }
        }
        if (this.args.upload.disableWal()) {
            this.executeUpdate("ALTER TABLE test_upload LOGGING");
        }
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"Custom warmup finished");
        this.dropAndCreate();
    }

    protected void init() {
    }

    protected abstract void warmup(Connection var1) throws Exception;

    @Override
    protected void setupData() throws Exception {
        this.queries = new QueryFactory(this.args.atomicMode());
        this.dropAndCreate();
    }

    protected abstract void upload(Connection var1) throws Exception;

    public final boolean test(Map<Object, Object> ctx) throws Exception {
        if (this.args.upload.disableWal()) {
            this.executeUpdate("ALTER TABLE test_upload NOLOGGING");
        }
        try (Connection uploadConn = this.uploadConnection();){
            if (this.args.upload.useStreaming()) {
                AbstractUploadBenchmark.executeUpdateOn(uploadConn, this.queries.turnOnStreaming(this.args.upload));
            }
            this.upload(uploadConn);
            if (this.args.upload.useStreaming()) {
                AbstractUploadBenchmark.executeUpdateOn(uploadConn, "SET STREAMING OFF");
            }
        }
        if (this.args.upload.disableWal()) {
            this.executeUpdate("ALTER TABLE test_upload LOGGING");
        }
        return true;
    }

    private void dropAndCreate() throws SQLException {
        this.executeUpdate("DROP TABLE IF EXISTS test_upload;");
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Creating table with schema: " + this.queries.createTable()));
        this.executeUpdate(this.queries.createTable());
        int idxCnt = this.args.upload.indexesCount();
        BenchmarkUtils.println((String)("Creating " + idxCnt + " indexes."));
        for (int i = 1; i <= idxCnt; ++i) {
            this.executeUpdate(this.queries.createIndex(i));
        }
    }

    public long count() throws SQLException {
        try (PreparedStatement cnt = ((Connection)this.conn.get()).prepareStatement("SELECT COUNT(id) FROM test_upload;");){
            long l;
            block12: {
                ResultSet rs = cnt.executeQuery();
                try {
                    rs.next();
                    l = rs.getLong(1);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"Tearing down");
        try {
            long cnt = this.count();
            if (cnt != this.insertRowsCnt) {
                String msg = "Rows count is incorrect: [actual=" + cnt + ", expected=" + this.insertRowsCnt + "]";
                BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("TearDown: " + msg));
                throw new RuntimeException(msg);
            }
            BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Test table contains " + cnt + " rows."));
        }
        finally {
            super.tearDown();
        }
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"TearDown successfully finished.");
    }

    private int executeUpdate(String updQry) throws SQLException {
        return AbstractUploadBenchmark.executeUpdateOn((Connection)this.conn.get(), updQry);
    }

    private static int executeUpdateOn(Connection c, String updQry) throws SQLException {
        try (PreparedStatement update = c.prepareStatement(updQry);){
            int n = update.executeUpdate();
            return n;
        }
    }

    private Connection uploadConnection() throws SQLException {
        Object urlParams = "";
        List<String> rawParams = this.args.upload.uploadJdbcParams();
        if (!rawParams.isEmpty()) {
            String kvList = String.join((CharSequence)"&", rawParams);
            urlParams = "?" + kvList;
        }
        return this.connection(this.url + (String)urlParams);
    }
}

