/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.TransactionProxy;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteAsyncSupport;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class TransactionProxyImpl<K, V>
implements TransactionProxy,
Externalizable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private GridNearTxLocal tx;
    @GridToStringExclude
    private GridCacheSharedContext<K, V> cctx;
    private boolean async;
    private IgniteFuture asyncRes;

    public TransactionProxyImpl() {
    }

    public TransactionProxyImpl(GridNearTxLocal tx, GridCacheSharedContext<K, V> cctx, boolean async) {
        assert (tx != null);
        assert (cctx != null);
        this.tx = tx;
        this.cctx = cctx;
        this.async = async;
    }

    public GridNearTxLocal tx() {
        return this.tx;
    }

    private void enter() {
        this.enter(false);
    }

    private void enter(boolean resume) {
        if (!resume && this.state() == TransactionState.SUSPENDED) {
            throw new IgniteException("Tx in SUSPENDED state. All operations except resume are prohibited.");
        }
        if (this.cctx.deploymentEnabled()) {
            this.cctx.deploy().onEnter();
        }
        this.tx.enterSystemSection();
        try {
            this.cctx.kernalContext().gateway().readLock();
        }
        catch (IllegalStateException | IgniteClientDisconnectedException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.cctx.kernalContext().gateway().readUnlock();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leave() {
        try {
            GridIntList cacheIds = this.tx.txState().cacheIds();
            for (int i = 0; i < cacheIds.size(); ++i) {
                int cacheId = cacheIds.get(i);
                GridCacheContext<K, V> ctx = this.cctx.cacheContext(cacheId);
                if (ctx == null) continue;
                CU.unwindEvicts(ctx);
            }
            this.tx.leaveSystemSection();
        }
        finally {
            this.cctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public IgniteUuid xid() {
        return this.tx.xid();
    }

    @Override
    public UUID nodeId() {
        if (this.async) {
            this.save(this.tx.nodeId());
        }
        return this.tx.nodeId();
    }

    @Override
    public long threadId() {
        if (this.async) {
            this.save(this.tx.threadId());
        }
        return this.tx.threadId();
    }

    @Override
    public long startTime() {
        if (this.async) {
            this.save(this.tx.startTime());
        }
        return this.tx.startTime();
    }

    @Override
    public TransactionIsolation isolation() {
        if (this.async) {
            this.save((Object)this.tx.isolation());
        }
        return this.tx.isolation();
    }

    @Override
    public TransactionConcurrency concurrency() {
        if (this.async) {
            this.save((Object)this.tx.concurrency());
        }
        return this.tx.concurrency();
    }

    @Override
    public boolean isInvalidate() {
        if (this.async) {
            this.save(this.tx.isInvalidate());
        }
        return this.tx.isInvalidate();
    }

    @Override
    public boolean implicit() {
        if (this.async) {
            this.save(this.tx.implicit());
        }
        return this.tx.implicit();
    }

    @Override
    public long timeout() {
        if (this.async) {
            this.save(this.tx.timeout());
        }
        return this.tx.timeout();
    }

    @Override
    public TransactionState state() {
        if (this.async) {
            this.save((Object)this.tx.state());
        }
        return this.tx.state();
    }

    @Override
    public void suspend() throws IgniteException {
        try (MTC.TraceSurroundings ignored = MTC.support(this.cctx.kernalContext().tracing().create(SpanType.TX_SUSPEND, MTC.span()));){
            this.enter();
            try {
                this.cctx.suspendTx(this.tx);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.leave();
            }
        }
    }

    @Override
    @Nullable
    public String label() {
        if (this.async) {
            this.save(this.tx.label());
        }
        return this.tx.label();
    }

    @Override
    public long timeout(long timeout) {
        return this.tx.timeout(timeout);
    }

    @Override
    public IgniteAsyncSupport withAsync() {
        return new TransactionProxyImpl<K, V>(this.tx, this.cctx, true);
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    @Override
    public <R> IgniteFuture<R> future() {
        return this.asyncRes;
    }

    @Override
    public boolean setRollbackOnly() {
        this.enter();
        try {
            boolean bl = this.tx.setRollbackOnly();
            return bl;
        }
        finally {
            this.leave();
        }
    }

    @Override
    public boolean isRollbackOnly() {
        this.enter();
        try {
            if (this.async) {
                this.save(this.tx.isRollbackOnly());
            }
            boolean bl = this.tx.isRollbackOnly();
            return bl;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        Span span = MTC.span();
        try (MTC.TraceSurroundings ignored = MTC.support(this.cctx.kernalContext().tracing().create(SpanType.TX_COMMIT, span));){
            this.enter();
            try {
                IgniteInternalFuture<IgniteInternalTx> commitFut = this.cctx.commitTxAsync(this.tx);
                if (this.async) {
                    this.saveFuture(commitFut);
                } else {
                    commitFut.get();
                }
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.leave();
            }
        }
        finally {
            span.end();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public IgniteFuture<Void> commitAsync() throws IgniteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Span span = MTC.span();
        try (MTC.TraceSurroundings ignored = MTC.support(this.cctx.kernalContext().tracing().create(SpanType.TX_CLOSE, span));){
            this.enter();
            try {
                this.cctx.endTx(this.tx);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.leave();
            }
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        Span span = MTC.span();
        try (MTC.TraceSurroundings ignored = MTC.support(this.cctx.kernalContext().tracing().create(SpanType.TX_ROLLBACK, span));){
            this.enter();
            try {
                IgniteInternalFuture rollbackFut = this.cctx.rollbackTxAsync(this.tx);
                if (this.async) {
                    this.asyncRes = new IgniteFutureImpl(rollbackFut);
                } else {
                    rollbackFut.get();
                }
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.leave();
            }
        }
        finally {
            span.end();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public IgniteFuture<Void> rollbackAsync() throws IgniteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void resume() throws IgniteException {
        try (MTC.TraceSurroundings ignored = MTC.support(this.cctx.kernalContext().tracing().create(SpanType.TX_RESUME, MTC.span()));){
            this.enter(true);
            try {
                this.cctx.resumeTx(this.tx);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.leave();
            }
        }
    }

    private void save(Object res) {
        this.asyncRes = new IgniteFinishedFutureImpl<Object>(res);
    }

    private void saveFuture(IgniteInternalFuture<IgniteInternalTx> fut) {
        this.asyncRes = this.createFuture(fut);
    }

    private IgniteFuture<?> createFuture(IgniteInternalFuture<IgniteInternalTx> fut) {
        IgniteInternalFuture<Transaction> fut0 = fut.chain(new CX1<IgniteInternalFuture<IgniteInternalTx>, Transaction>(){

            @Override
            public Transaction applyx(IgniteInternalFuture<IgniteInternalTx> fut) throws IgniteCheckedException {
                fut.get();
                return TransactionProxyImpl.this;
            }
        });
        return new IgniteFutureImpl<Transaction>(fut0);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tx = (GridNearTxLocal)in.readObject();
    }

    public String toString() {
        return S.toString(TransactionProxyImpl.class, this);
    }
}

