/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.records;

import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.traversal.algorithm.records.Records;
import org.apache.hugegraph.traversal.algorithm.records.record.Record;
import org.apache.hugegraph.traversal.algorithm.records.record.RecordFactory;
import org.apache.hugegraph.traversal.algorithm.records.record.RecordType;
import org.apache.hugegraph.util.collection.ObjectIntMapping;
import org.apache.hugegraph.util.collection.ObjectIntMappingFactory;

public abstract class AbstractRecords
implements Records {
    private final ObjectIntMapping<Id> idMapping;
    private final RecordType type;
    private final boolean concurrent;
    private Record currentRecord;
    private Record parentRecord;

    public AbstractRecords(RecordType type, boolean concurrent) {
        this.type = type;
        this.concurrent = concurrent;
        this.parentRecord = null;
        this.idMapping = ObjectIntMappingFactory.newObjectIntMapping(this.concurrent);
    }

    @PerfUtil.Watched
    protected final int code(Id id) {
        long l;
        if (id.number() && 0L <= (l = id.asLong()) && l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        int code = this.idMapping.object2Code(id);
        assert (code > 0);
        return -code;
    }

    @PerfUtil.Watched
    protected final Id id(int code) {
        if (code >= 0) {
            return IdGenerator.of(code);
        }
        return this.idMapping.code2Object(-code);
    }

    protected final Record newRecord() {
        return RecordFactory.newRecord(this.type, this.concurrent);
    }

    protected final Record currentRecord() {
        return this.currentRecord;
    }

    protected void currentRecord(Record currentRecord, Record parentRecord) {
        this.parentRecord = parentRecord;
        this.currentRecord = currentRecord;
    }

    protected Record parentRecord() {
        return this.parentRecord;
    }
}

