/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.store.BackendAction;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.iterator.ExtendableIterator;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Action;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class BackendMutation {
    private final MutationTable updates;

    public BackendMutation() {
        this.updates = new MutationTable();
    }

    public BackendMutation(int initialCapacity) {
        this.updates = new MutationTable(initialCapacity);
    }

    @PerfUtil.Watched(prefix="mutation")
    public void add(BackendEntry entry, Action action) {
        Id id = entry.id();
        assert (id != null);
        if (this.updates.containsKey(entry.type(), id)) {
            this.optimizeUpdates(entry, action);
        } else {
            this.updates.put(entry.type(), id, BackendAction.of(action, entry));
        }
    }

    public void put(BackendEntry entry, Action action) {
        Id id = entry.id();
        this.updates.put(entry.type(), id, BackendAction.of(action, entry));
    }

    @PerfUtil.Watched(prefix="mutation")
    private void optimizeUpdates(BackendEntry entry, Action action) {
        Id id = entry.id();
        assert (id != null);
        List<BackendAction> items = this.updates.get(entry.type(), id);
        assert (items != null);
        boolean ignoreCurrent = false;
        Iterator<BackendAction> iter = items.iterator();
        block6: while (iter.hasNext()) {
            BackendAction originItem = iter.next();
            Action originAction = originItem.action();
            switch (action) {
                case INSERT: {
                    iter.remove();
                    break;
                }
                case DELETE: {
                    if (originAction == Action.INSERT) {
                        throw BackendMutation.incompatibleActionException(action, originAction);
                    }
                    if (originAction == Action.DELETE) {
                        ignoreCurrent = true;
                        break;
                    }
                    iter.remove();
                    break;
                }
                case APPEND: {
                    if (entry.type().isUniqueIndex() && originAction == Action.APPEND) {
                        throw new IllegalArgumentException(String.format("Unique constraint conflict is found in transaction between %s and %s", entry, originItem.entry()));
                    }
                    if (originAction == Action.INSERT || originAction == Action.DELETE) {
                        throw BackendMutation.incompatibleActionException(action, originAction);
                    }
                    Id subId = entry.subId();
                    Id originSubId = originItem.entry().subId();
                    assert (subId != null);
                    if (subId != originSubId && !subId.equals(originSubId)) continue block6;
                    iter.remove();
                    break;
                }
                case ELIMINATE: {
                    if (originAction == Action.INSERT || originAction == Action.DELETE) {
                        throw BackendMutation.incompatibleActionException(action, originAction);
                    }
                    Id subId = entry.subId();
                    Id originSubId = originItem.entry().subId();
                    assert (subId != null);
                    if (subId != originSubId && !subId.equals(originSubId)) continue block6;
                    iter.remove();
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unknown mutate action: %s", action));
                }
            }
        }
        if (!ignoreCurrent) {
            items.add(BackendAction.of(action, entry));
        }
    }

    private static HugeException incompatibleActionException(Action newAction, Action originAction) {
        return new HugeException("The action '%s' is incompatible with action '%s'", newAction, originAction);
    }

    public void merge(BackendMutation mutation) {
        E.checkNotNull((Object)mutation, (String)"mutation");
        Iterator<BackendAction> it = mutation.mutation();
        while (it.hasNext()) {
            BackendAction item = it.next();
            this.add(item.entry(), item.action());
        }
    }

    public Set<HugeType> types() {
        return this.updates.keys();
    }

    public Iterator<BackendAction> mutation() {
        return this.updates.values();
    }

    public Iterator<BackendAction> mutation(HugeType type) {
        return this.updates.get(type);
    }

    public List<BackendAction> mutation(HugeType type, Id id) {
        return this.updates.get(type, id);
    }

    public boolean contains(BackendEntry entry, Action action) {
        List<BackendAction> items = this.updates.get(entry.type(), entry.id());
        if (items == null || items.isEmpty()) {
            return false;
        }
        for (BackendAction item : items) {
            if (!item.action().equals(action)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HugeType type, Action action) {
        Iterator<BackendAction> i = this.updates.get(type);
        while (i.hasNext()) {
            BackendAction entry = i.next();
            if (entry.action() != action) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.updates.size() == 0;
    }

    public int size() {
        return this.updates.size();
    }

    public void clear() {
        this.updates.clear();
    }

    public String toString() {
        return String.format("BackendMutation{mutations=%s}", this.updates);
    }

    private static class MutationTable {
        private final Map<HugeType, Map<Id, List<BackendAction>>> mutations;

        public MutationTable() {
            this.mutations = InsertionOrderUtil.newMap();
        }

        public MutationTable(int initialCapacity) {
            this.mutations = InsertionOrderUtil.newMap((int)initialCapacity);
        }

        public void put(HugeType type, Id id, BackendAction mutation) {
            ArrayList<BackendAction> items;
            Map table = this.mutations.get(type);
            if (table == null) {
                table = InsertionOrderUtil.newMap();
                this.mutations.put(type, table);
            }
            if ((items = (ArrayList<BackendAction>)table.get(id)) == null) {
                items = new ArrayList<BackendAction>();
                table.put(id, items);
            }
            items.add(mutation);
        }

        public boolean containsKey(HugeType type, Id id) {
            Map<Id, List<BackendAction>> table = this.mutations.get(type);
            return table != null && table.containsKey(id);
        }

        public List<BackendAction> get(HugeType type, Id id) {
            Map<Id, List<BackendAction>> table = this.mutations.get(type);
            if (table == null) {
                return null;
            }
            return table.get(id);
        }

        public Iterator<BackendAction> get(HugeType type) {
            ExtendableIterator rs = new ExtendableIterator();
            Map<Id, List<BackendAction>> table = this.mutations.get(type);
            if (table != null) {
                for (List<BackendAction> items : table.values()) {
                    rs.extend(items.iterator());
                }
            }
            return rs;
        }

        public Set<HugeType> keys() {
            return this.mutations.keySet();
        }

        public Iterator<BackendAction> values() {
            ExtendableIterator rs = new ExtendableIterator();
            for (Map<Id, List<BackendAction>> table : this.mutations.values()) {
                for (List<BackendAction> items : table.values()) {
                    rs.extend(items.iterator());
                }
            }
            return rs;
        }

        public int size() {
            int size = 0;
            for (Map<Id, List<BackendAction>> m : this.mutations.values()) {
                for (List<BackendAction> actions : m.values()) {
                    size += actions.size();
                }
            }
            return size;
        }

        public void clear() {
            this.mutations.clear();
        }
    }
}

