/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.type.Nameable;
import org.apache.hugegraph.util.E;

public class ResourceObject<V> {
    private final String graph;
    private final ResourceType type;
    private final V operated;

    public ResourceObject(String graph, ResourceType type, V operated) {
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)((Object)type), (String)"type");
        E.checkNotNull(operated, (String)"operated");
        this.graph = graph;
        this.type = type;
        this.operated = operated;
    }

    public String graph() {
        return this.graph;
    }

    public ResourceType type() {
        return this.type;
    }

    public V operated() {
        return this.operated;
    }

    public String toString() {
        Object operated = this.operated;
        if (this.type.isAuth()) {
            operated = ((SchemaDefine.AuthElement)this.operated).idString();
        }
        String typeStr = this.type.toString();
        String operatedStr = operated.toString();
        int capacity = this.graph.length() + typeStr.length() + operatedStr.length() + 36;
        StringBuilder sb = new StringBuilder(capacity);
        return sb.append("Resource{graph=").append(this.graph).append(",type=").append(typeStr).append(",operated=").append(operatedStr).append("}").toString();
    }

    public static ResourceObject<SchemaElement> of(String graph, SchemaElement elem) {
        ResourceType resType = ResourceType.from(elem.type());
        return new ResourceObject<SchemaElement>(graph, resType, elem);
    }

    public static ResourceObject<HugeElement> of(String graph, HugeElement elem) {
        ResourceType resType = ResourceType.from(elem.type());
        return new ResourceObject<HugeElement>(graph, resType, elem);
    }

    public static ResourceObject<SchemaDefine.AuthElement> of(String graph, SchemaDefine.AuthElement elem) {
        return new ResourceObject<SchemaDefine.AuthElement>(graph, elem.type(), elem);
    }

    public static ResourceObject<?> of(String graph, ResourceType type, Nameable elem) {
        return new ResourceObject<Nameable>(graph, type, elem);
    }
}

