/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.recognition.Recognition;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class StopRecognition
implements Recognition {
    private static final Log LOG = LogFactory.getLog();
    private static final long serialVersionUID = 7041503137429986566L;
    private Set<String> stop = new HashSet<String>();
    private Set<String> natureStop = new HashSet<String>();
    private Set<Pattern> regexList = new HashSet<Pattern>();

    public StopRecognition insertStopWords(Collection<String> filterWords) {
        this.stop.addAll(filterWords);
        return this;
    }

    public StopRecognition insertStopWords(String ... stopWords) {
        for (String words : stopWords) {
            this.stop.add(words);
        }
        return this;
    }

    public void insertStopNatures(String ... stopNatures) {
        for (String natureStr : stopNatures) {
            this.natureStop.add(natureStr);
        }
    }

    public void insertStopRegexes(String ... regexes) {
        for (String regex : regexes) {
            try {
                this.regexList.add(Pattern.compile(regex));
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error("regex err : " + regex, (Throwable)e);
            }
        }
    }

    @Override
    public void recognition(Result result) {
        List<Term> list = result.getTerms();
        Iterator<Term> iterator = list.iterator();
        while (iterator.hasNext()) {
            Term term = iterator.next();
            if (!this.filter(term)) continue;
            iterator.remove();
        }
    }

    public boolean filter(Term term) {
        if (this.stop.size() > 0 && this.stop.contains(term.getName())) {
            return true;
        }
        if (this.natureStop.size() > 0 && this.natureStop.contains(term.natrue().natureStr)) {
            return true;
        }
        if (this.regexList.size() > 0) {
            for (Pattern stopwordPattern : this.regexList) {
                if (!stopwordPattern.matcher(term.getName()).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.stop.clear();
        this.natureStop.clear();
        this.regexList.clear();
    }
}

