/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util.collection;

import org.apache.hugegraph.util.collection.IntIterator;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;

public class Int2IntsMap {
    private static final int INIT_KEY_CAPACITY = 16;
    private static final int CHUNK_SIZE = 10;
    private static final int EXPANSION_FACTOR = 2;
    private static final int OFFSET_NEXT_FREE = 0;
    private static final int OFFSET_SIZE = 1;
    private static final int OFFSET_FIRST_CHUNK_DATA = 2;
    private final IntIntHashMap chunkMap = new IntIntHashMap(16);
    private int[] chunkTable = new int[160];
    private int nextFreeChunk = 0;

    public void add(int key, int value) {
        if (this.chunkMap.containsKey(key)) {
            int firstChunk = this.chunkMap.get(key);
            int nextFree = this.chunkTable[firstChunk + 0];
            if (!this.endOfChunk(nextFree)) {
                this.chunkTable[nextFree] = value;
                int n = firstChunk + 0;
                this.chunkTable[n] = this.chunkTable[n] + 1;
            } else {
                this.ensureCapacity();
                int lastEntryOfChunk = nextFree;
                this.chunkTable[lastEntryOfChunk] = this.nextFreeChunk;
                nextFree = this.nextFreeChunk;
                this.chunkTable[nextFree] = value;
                this.chunkTable[firstChunk + 0] = nextFree + 1;
                this.nextFreeChunk += 10;
            }
            int n = firstChunk + 1;
            this.chunkTable[n] = this.chunkTable[n] + 1;
        } else {
            this.ensureCapacity();
            this.chunkMap.put(key, this.nextFreeChunk);
            int firstChunk = this.nextFreeChunk;
            int nextFree = firstChunk + 2;
            this.chunkTable[firstChunk + 0] = nextFree + 1;
            this.chunkTable[firstChunk + 1] = 1;
            this.chunkTable[nextFree] = value;
            this.nextFreeChunk += 10;
        }
    }

    public boolean containsKey(int key) {
        return this.chunkMap.containsKey(key);
    }

    public int[] getValues(int key) {
        int firstChunk = this.chunkMap.getIfAbsent(key, -1);
        if (firstChunk == -1) {
            return IntIterator.EMPTY_INTS;
        }
        int size = this.chunkTable[firstChunk + 1];
        int[] values = new int[size];
        int position = firstChunk + 2;
        int i = 0;
        while (i < size) {
            if (!this.endOfChunk(position)) {
                values[i++] = this.chunkTable[position++];
                continue;
            }
            position = this.chunkTable[position];
        }
        return values;
    }

    public org.eclipse.collections.api.iterator.IntIterator keys() {
        return this.chunkMap.keySet().intIterator();
    }

    public int size() {
        return this.chunkMap.size();
    }

    public String toString() {
        int capacity = (this.size() + 1) * 64;
        StringBuilder sb = new StringBuilder(capacity);
        sb.append("{");
        org.eclipse.collections.api.iterator.IntIterator iter = this.keys();
        while (iter.hasNext()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            int key = iter.next();
            sb.append(key).append(": [");
            int[] values = this.getValues(key);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(values[i]);
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private boolean endOfChunk(int position) {
        return (position + 1) % 10 == 0;
    }

    private void ensureCapacity() {
        if (this.nextFreeChunk >= this.chunkTable.length) {
            this.expand();
        }
    }

    private void expand() {
        int currentSize = this.chunkTable.length;
        int[] newTable = new int[currentSize * 2];
        System.arraycopy(this.chunkTable, 0, newTable, 0, currentSize);
        this.chunkTable = newTable;
    }
}

