/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.YAMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeFactory;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class ConfigUtil {
    private static final Logger LOG = Log.logger(ConfigUtil.class);
    private static final String NODE_GRAPHS = "graphs";
    private static final String CONF_SUFFIX = ".properties";
    private static final String CHARSET = "UTF-8";

    public static void checkGremlinConfig(String conf) {
        Parameters params = new Parameters();
        try {
            FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(YAMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.fileBased().setFileName(conf)});
            YAMLConfiguration config = (YAMLConfiguration)builder.getConfiguration();
            List nodes = config.childConfigurationsAt(NODE_GRAPHS);
            if (nodes == null || nodes.isEmpty()) {
                return;
            }
            E.checkArgument((nodes.size() == 1 ? 1 : 0) != 0, (String)"Not allowed to specify multiple '%s' nodes in config file '%s'", (Object[])new Object[]{NODE_GRAPHS, conf});
            ImmutableNode root = null;
            NodeHandler nodeHandler = null;
            for (HierarchicalConfiguration node : nodes) {
                NodeModel nodeModel = node.getNodeModel();
                E.checkArgument((nodeModel != null && (nodeHandler = nodeModel.getNodeHandler()) != null && (root = (ImmutableNode)nodeHandler.getRootNode()) != null ? 1 : 0) != 0, (String)"Node '%s' must contain root", (Object[])new Object[]{node});
            }
        }
        catch (ConfigurationException e) {
            throw new HugeException("Failed to load yaml config file '%s'", conf);
        }
    }

    public static Map<String, String> scanGraphsDir(String graphsDirPath) {
        LOG.info("Scanning option 'graphs' directory '{}'", (Object)graphsDirPath);
        File graphsDir = new File(graphsDirPath);
        E.checkArgument((graphsDir.exists() && graphsDir.isDirectory() ? 1 : 0) != 0, (String)"Please ensure the path '%s' of option 'graphs' exist and it's a directory", (Object[])new Object[]{graphsDir});
        File[] confFiles = graphsDir.listFiles((dir, name) -> name.endsWith(CONF_SUFFIX));
        E.checkNotNull((Object)confFiles, (String)"graph configuration files");
        Map graphConfs = InsertionOrderUtil.newMap();
        for (File confFile : confFiles) {
            String name2 = StringUtils.substringBefore((String)confFile.getName(), (String)CONF_SUFFIX);
            HugeFactory.checkGraphName(name2, confFile.getPath());
            graphConfs.put(name2, confFile.getPath());
        }
        return graphConfs;
    }

    public static String writeToFile(String dir, String graphName, HugeConfig config) {
        File file = FileUtils.getFile((String[])new String[]{dir});
        E.checkArgument((boolean)file.exists(), (String)"The directory '%s' must exist", (Object[])new Object[]{dir});
        String fileName = file.getPath() + File.separator + graphName + CONF_SUFFIX;
        try {
            File newFile = FileUtils.getFile((String[])new String[]{fileName});
            config.save(newFile);
            LOG.info("Write HugeConfig to file: '{}'", (Object)fileName);
        }
        catch (ConfigurationException e) {
            throw new HugeException("Failed to write HugeConfig to file '%s'", (Throwable)e, fileName);
        }
        return fileName;
    }

    public static void deleteFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new HugeException("Failed to delete HugeConfig file '%s'", (Throwable)e, file);
        }
    }

    public static PropertiesConfiguration buildConfig(String configText) {
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)configText), (String)"The config text can't be null or empty", (Object[])new Object[0]);
        PropertiesConfiguration propConfig = new PropertiesConfiguration();
        try {
            StringReader in = new StringReader(configText);
            propConfig.read((Reader)in);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read config options", e);
        }
        return propConfig;
    }
}

