/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.masterelection;

import java.util.Objects;
import org.apache.hugegraph.masterelection.GlobalMasterInfo;
import org.apache.hugegraph.masterelection.RoleListener;
import org.apache.hugegraph.masterelection.StateMachineContext;
import org.apache.hugegraph.task.TaskManager;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class StandardRoleListener
implements RoleListener {
    private static final Logger LOG = Log.logger(StandardRoleListener.class);
    private final TaskManager taskManager;
    private final GlobalMasterInfo roleInfo;
    private volatile boolean selfIsMaster;

    public StandardRoleListener(TaskManager taskManager, GlobalMasterInfo roleInfo) {
        this.taskManager = taskManager;
        this.taskManager.enableRoleElection();
        this.roleInfo = roleInfo;
        this.selfIsMaster = false;
    }

    @Override
    public void onAsRoleMaster(StateMachineContext context) {
        if (!this.selfIsMaster) {
            this.taskManager.onAsRoleMaster();
            LOG.info("Server {} change to master role", (Object)context.config().node());
        }
        this.updateMasterInfo(context);
        this.selfIsMaster = true;
    }

    @Override
    public void onAsRoleWorker(StateMachineContext context) {
        if (this.selfIsMaster) {
            this.taskManager.onAsRoleWorker();
            LOG.info("Server {} change to worker role", (Object)context.config().node());
        }
        this.updateMasterInfo(context);
        this.selfIsMaster = false;
    }

    @Override
    public void onAsRoleCandidate(StateMachineContext context) {
    }

    @Override
    public void onAsRoleAbdication(StateMachineContext context) {
        if (this.selfIsMaster) {
            this.taskManager.onAsRoleWorker();
            LOG.info("Server {} change to worker role", (Object)context.config().node());
        }
        this.updateMasterInfo(context);
        this.selfIsMaster = false;
    }

    @Override
    public void error(StateMachineContext context, Throwable e) {
        LOG.error("Server {} exception occurred", (Object)context.config().node(), (Object)e);
    }

    @Override
    public void unknown(StateMachineContext context) {
        if (this.selfIsMaster) {
            this.taskManager.onAsRoleWorker();
            LOG.info("Server {} change to worker role", (Object)context.config().node());
        }
        this.updateMasterInfo(context);
        this.selfIsMaster = false;
    }

    public void updateMasterInfo(StateMachineContext context) {
        StateMachineContext.MasterServerInfo master = context.master();
        if (master == null) {
            this.roleInfo.resetMasterInfo();
            return;
        }
        boolean isMaster = Objects.equals(context.node(), master.node());
        this.roleInfo.masterInfo(isMaster, master.url());
    }
}

