/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.comm;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.AbstractCommAlgorithm;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

public class WeakConnectedComponent
extends AbstractCommAlgorithm {
    protected static final Logger LOG = Log.logger(WeakConnectedComponent.class);

    @Override
    public String name() {
        return "weak_connected_component";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        WeakConnectedComponent.times(parameters);
        WeakConnectedComponent.directionOutIn(parameters);
        WeakConnectedComponent.degree(parameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.connectedComponent(WeakConnectedComponent.times(parameters), WeakConnectedComponent.directionOutIn(parameters), WeakConnectedComponent.degree(parameters));
            return object;
        }
        catch (Throwable e) {
            job.graph().tx().rollback();
            throw e;
        }
    }

    protected static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        private final Map<Id, Id> vertexComponentMap = new HashMap<Id, Id>();

        public Traverser(UserJob<Object> job) {
            super(job);
        }

        public Object connectedComponent(int maxTimes, Directions direction, long degree) {
            int times;
            this.initSchema();
            this.initVertexComponentMap();
            for (times = 0; times < maxTimes; ++times) {
                long changeCount = 0L;
                Id currentSourceVertexId = null;
                Iterator<Edge> edges = this.edges(direction);
                ArrayList<Id> adjacentVertices = new ArrayList<Id>();
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id sourceVertexId = edge.ownerVertex().id();
                    Id targetVertexId = edge.otherVertex().id();
                    if (currentSourceVertexId == null) {
                        currentSourceVertexId = sourceVertexId;
                        adjacentVertices.add(targetVertexId);
                        continue;
                    }
                    if (currentSourceVertexId.equals(sourceVertexId)) {
                        if ((long)adjacentVertices.size() >= degree) continue;
                        adjacentVertices.add(targetVertexId);
                        continue;
                    }
                    changeCount += this.findAndSetMinComponent(currentSourceVertexId, adjacentVertices);
                    adjacentVertices = new ArrayList();
                    currentSourceVertexId = sourceVertexId;
                    adjacentVertices.add(targetVertexId);
                }
                LOG.debug("iterationTimes:{}, changeCount:{}", (Object)times, (Object)(changeCount += this.findAndSetMinComponent(currentSourceVertexId, adjacentVertices)));
                if (changeCount == 0L) break;
            }
            int compCount = this.writeBackValue();
            return ImmutableMap.of((Object)"components", (Object)compCount, (Object)"iteration_times", (Object)times, (Object)"times", (Object)maxTimes);
        }

        private void initSchema() {
            String cl = "c_label";
            SchemaManager schema = this.graph().schema();
            schema.propertyKey(cl).asText().ifNotExist().create();
            for (VertexLabel vl : schema.getVertexLabels()) {
                schema.vertexLabel(vl.name()).properties(cl).nullableKeys(cl).append();
            }
        }

        private void initVertexComponentMap() {
            Iterator<Vertex> vertices = this.vertices();
            while (vertices.hasNext()) {
                Id id = ((HugeVertex)vertices.next()).id();
                this.vertexComponentMap.put(id, id);
            }
        }

        private long findAndSetMinComponent(Id sourceVertexId, List<Id> adjacentVertices) {
            if (!this.vertexComponentMap.containsKey(sourceVertexId)) {
                return 0L;
            }
            Id min = this.findMinComponent(sourceVertexId, adjacentVertices);
            return this.updateComponentIfNeeded(min, sourceVertexId, adjacentVertices);
        }

        private Id findMinComponent(Id sourceVertexId, List<Id> adjacentVertices) {
            Id min = this.vertexComponentMap.get(sourceVertexId);
            for (Id vertex : adjacentVertices) {
                Id comp = this.vertexComponentMap.get(vertex);
                if (comp == null || comp.compareTo(min) >= 0) continue;
                min = comp;
            }
            return min;
        }

        private long updateComponentIfNeeded(Id min, Id sourceVertexId, List<Id> adjacentVertices) {
            long changedCount = 0L;
            Id comp = this.vertexComponentMap.get(sourceVertexId);
            if (comp.compareTo(min) > 0) {
                this.vertexComponentMap.put(sourceVertexId, min);
                ++changedCount;
            }
            for (Id vertex : adjacentVertices) {
                comp = this.vertexComponentMap.get(vertex);
                if (comp == null || comp.compareTo(min) <= 0) continue;
                this.vertexComponentMap.put(vertex, min);
                ++changedCount;
            }
            return changedCount;
        }

        private int writeBackValue() {
            HashMap<Id, Integer> componentIndexMap = new HashMap<Id, Integer>();
            int index = 0;
            for (Map.Entry<Id, Id> entry : this.vertexComponentMap.entrySet()) {
                Vertex vertex;
                Id comp = entry.getValue();
                Integer componentIndex = (Integer)componentIndexMap.get(comp);
                if (componentIndex == null) {
                    componentIndex = index;
                    componentIndexMap.put(comp, componentIndex);
                    ++index;
                }
                if ((vertex = this.vertex(entry.getKey())) == null) continue;
                vertex.property("c_label", (Object)String.valueOf(componentIndex));
                this.commitIfNeeded();
            }
            this.graph().tx().commit();
            return index;
        }
    }
}

