/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.AbstractLifeCycle;
import com.alipay.remoting.BoltClient;
import com.alipay.remoting.config.BoltOption;
import com.alipay.remoting.config.BoltOptions;
import com.alipay.remoting.config.ConfigManager;
import com.alipay.remoting.config.Configurable;
import com.alipay.remoting.config.ConfigurableInstance;
import com.alipay.remoting.config.configs.ConfigContainer;
import com.alipay.remoting.config.configs.ConfigItem;
import com.alipay.remoting.config.configs.ConfigType;
import com.alipay.remoting.config.configs.DefaultConfigContainer;
import com.alipay.remoting.config.switches.GlobalSwitch;

public abstract class AbstractBoltClient
extends AbstractLifeCycle
implements BoltClient,
ConfigurableInstance {
    private final BoltOptions options = new BoltOptions();
    private final ConfigType configType = ConfigType.CLIENT_SIDE;
    private final GlobalSwitch globalSwitch = new GlobalSwitch();
    private final ConfigContainer configContainer = new DefaultConfigContainer();

    @Override
    public <T> T option(BoltOption<T> option) {
        return this.options.option(option);
    }

    @Override
    public <T> Configurable option(BoltOption<T> option, T value) {
        this.options.option(option, value);
        return this;
    }

    @Override
    public ConfigContainer conf() {
        return this.configContainer;
    }

    @Override
    public GlobalSwitch switches() {
        return this.globalSwitch;
    }

    @Override
    public void initWriteBufferWaterMark(int low, int high) {
        this.configContainer.set(this.configType, ConfigItem.NETTY_BUFFER_LOW_WATER_MARK, low);
        this.configContainer.set(this.configType, ConfigItem.NETTY_BUFFER_HIGH_WATER_MARK, high);
    }

    @Override
    public int netty_buffer_low_watermark() {
        Object config = this.configContainer.get(this.configType, ConfigItem.NETTY_BUFFER_LOW_WATER_MARK);
        if (config != null) {
            return (Integer)config;
        }
        return ConfigManager.netty_buffer_low_watermark();
    }

    @Override
    public int netty_buffer_high_watermark() {
        Object config = this.configContainer.get(this.configType, ConfigItem.NETTY_BUFFER_HIGH_WATER_MARK);
        if (config != null) {
            return (Integer)config;
        }
        return ConfigManager.netty_buffer_high_watermark();
    }
}

