/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.builder;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.loader.builder.SchemaCache;
import org.apache.hugegraph.loader.constant.Constants;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.util.DataTypeUtil;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.constant.IdStrategy;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.structure.schema.PropertyKey;
import org.apache.hugegraph.structure.schema.SchemaLabel;
import org.apache.hugegraph.structure.schema.VertexLabel;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.LongEncoding;
import org.apache.spark.sql.Row;

public abstract class ElementBuilder<GE extends GraphElement> {
    private final InputStruct struct;
    private final SchemaCache schema;
    private final CharsetEncoder encoder;
    private final ByteBuffer buffer;

    public ElementBuilder(LoadContext context, InputStruct struct) {
        this.struct = struct;
        this.schema = context.schemaCache();
        this.encoder = Constants.CHARSET.newEncoder();
        this.buffer = ByteBuffer.allocate(128);
    }

    public abstract ElementMapping mapping();

    public abstract List<GE> build(String[] var1, Object[] var2);

    public abstract List<GE> build(Row var1);

    public abstract SchemaLabel schemaLabel();

    protected abstract Collection<String> nonNullableKeys();

    protected abstract boolean isIdField(String var1);

    protected Collection<String> nonNullableKeys(SchemaLabel schemaLabel) {
        return CollectionUtils.subtract((Collection)schemaLabel.properties(), (Collection)schemaLabel.nullableKeys());
    }

    protected VertexKVPairs newKVPairs(VertexLabel vertexLabel, boolean unfold) {
        IdStrategy idStrategy = vertexLabel.idStrategy();
        if (idStrategy.isCustomize()) {
            if (unfold) {
                return new VertexFlatIdKVPairs(vertexLabel);
            }
            return new VertexIdKVPairs(vertexLabel);
        }
        assert (idStrategy.isPrimaryKey());
        if (unfold) {
            return new VertexFlatPkKVPairs(vertexLabel);
        }
        return new VertexPkKVPairs(vertexLabel);
    }

    protected boolean retainField(String fieldName, Object fieldValue) {
        ElementMapping mapping = this.mapping();
        Set<String> selectedFields = mapping.selectedFields();
        Set<String> ignoredFields = mapping.ignoredFields();
        if (!selectedFields.isEmpty() && !selectedFields.contains(fieldName)) {
            return false;
        }
        if (!ignoredFields.isEmpty() && ignoredFields.contains(fieldName)) {
            return false;
        }
        String mappedKey = mapping.mappingField(fieldName);
        Set nullableKeys = this.schemaLabel().nullableKeys();
        Set<Object> nullValues = mapping.nullValues();
        if (nullableKeys.isEmpty() || nullValues.isEmpty()) {
            return true;
        }
        return !nullableKeys.contains(mappedKey) || !nullValues.contains(fieldValue);
    }

    protected void addProperty(GraphElement element, String key, Object value) {
        this.addProperty(element, key, value, true);
    }

    protected void addProperty(GraphElement element, String key, Object value, boolean needConvert) {
        if (needConvert) {
            value = this.convertPropertyValue(key, value);
        }
        element.property(key, value);
    }

    protected void addProperties(GraphElement element, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.checkFieldValue(key, value);
            value = this.convertPropertyValue(key, value);
            element.property(key, value);
        }
    }

    protected void checkNonNullableKeys(GraphElement element) {
        Collection<String> requiredKeys;
        Set keys = element.properties().keySet();
        if (!keys.containsAll(requiredKeys = this.nonNullableKeys())) {
            Collection missed = CollectionUtils.subtract(requiredKeys, keys);
            E.checkArgument((boolean)false, (String)"All non-null property keys %s of '%s' must be set, but missed keys %s", (Object[])new Object[]{requiredKeys, this.schemaLabel().name(), missed});
        }
    }

    protected PropertyKey getPropertyKey(String name) {
        return this.schema.getPropertyKey(name);
    }

    protected VertexLabel getVertexLabel(String name) {
        return this.schema.getVertexLabel(name);
    }

    protected EdgeLabel getEdgeLabel(String name) {
        return this.schema.getEdgeLabel(name);
    }

    protected Object mappingValue(String fieldName, Object fieldValue) {
        if (this.mapping().mappingValues().isEmpty()) {
            return fieldValue;
        }
        String fieldStrValue = String.valueOf(fieldValue);
        return this.mapping().mappingValue(fieldName, fieldStrValue);
    }

    private void customizeId(VertexLabel vertexLabel, Vertex vertex, String idField, Object idValue) {
        E.checkArgumentNotNull((Object)idField, (String)"The vertex id field can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)idValue, (String)"The vertex id value can't be null", (Object[])new Object[0]);
        IdStrategy idStrategy = vertexLabel.idStrategy();
        if (idStrategy.isCustomizeString()) {
            String id = (String)idValue;
            this.checkVertexIdLength(id);
            vertex.id((Object)id);
        } else if (idStrategy.isCustomizeNumber()) {
            Long id = DataTypeUtil.parseNumber(idField, idValue);
            vertex.id((Object)id);
        } else {
            assert (idStrategy.isCustomizeUuid());
            UUID id = DataTypeUtil.parseUUID(idField, idValue);
            vertex.id((Object)id);
        }
    }

    private Object convertPropertyValue(String key, Object rawValue) {
        PropertyKey propertyKey = this.getPropertyKey(key);
        InputSource inputSource = this.struct.input();
        return DataTypeUtil.convert(rawValue, propertyKey, inputSource);
    }

    private void checkFieldValue(String fieldName, Object fieldValue) {
        if (this.mapping().mappingValues().isEmpty() || !this.mapping().mappingValues().containsKey(fieldName)) {
            return;
        }
        E.checkArgument((fieldValue != null ? 1 : 0) != 0, (String)"The field value can't be null", (Object[])new Object[0]);
        E.checkArgument((boolean)DataTypeUtil.isSimpleValue(fieldValue), (String)"The field value must be simple type, actual is '%s'", (Object[])new Object[]{fieldValue.getClass()});
    }

    private boolean vertexIdEmpty(VertexLabel vertexLabel, Vertex vertex) {
        IdStrategy idStrategy = vertexLabel.idStrategy();
        if (idStrategy.isCustomizeString()) {
            Object vertexId = vertex.id();
            return vertexId == null || StringUtils.isEmpty((CharSequence)((String)vertexId));
        }
        return false;
    }

    private void checkPrimaryValuesValid(VertexLabel vertexLabel, Object[] primaryValues) {
        List primaryKeys = vertexLabel.primaryKeys();
        E.checkArgument((primaryKeys.size() == primaryValues.length ? 1 : 0) != 0, (String)"Missing some primary key values, expect %s, but only got %s for vertex label '%s'", (Object[])new Object[]{primaryKeys, Arrays.toString(primaryValues), vertexLabel});
        for (int i = 0; i < primaryKeys.size(); ++i) {
            E.checkArgument((primaryValues[i] != null ? 1 : 0) != 0, (String)"Make sure the value of the primary key '%s' is not empty, or check whether the headers or field_mapping are configured correctly", (Object[])new Object[]{primaryKeys.get(i)});
        }
    }

    private String spliceVertexId(VertexLabel vertexLabel, Object ... primaryValues) {
        StringBuilder vertexId = new StringBuilder();
        StringBuilder vertexKeysId = new StringBuilder();
        for (Object value : primaryValues) {
            String pkValue = value instanceof Number || value instanceof Date ? LongEncoding.encodeNumber((Object)value) : String.valueOf(value);
            if (StringUtils.containsAny((CharSequence)pkValue, (CharSequence[])Constants.SEARCH_LIST)) {
                pkValue = StringUtils.replaceEach((String)pkValue, (String[])Constants.SEARCH_LIST, (String[])Constants.TARGET_LIST);
            }
            vertexKeysId.append(pkValue);
            vertexKeysId.append("!");
        }
        vertexId.append(vertexLabel.id()).append(":").append((CharSequence)vertexKeysId);
        vertexId.deleteCharAt(vertexId.length() - 1);
        return vertexId.toString();
    }

    private void checkVertexIdLength(String id) {
        this.encoder.reset();
        this.buffer.clear();
        CoderResult r = this.encoder.encode(CharBuffer.wrap(id.toCharArray()), this.buffer, true);
        E.checkArgument((boolean)r.isUnderflow(), (String)"The vertex id length exceeds limit %s : '%s'", (Object[])new Object[]{128, id});
    }

    private boolean isEmptyPkValue(Object pkValue) {
        if (pkValue == null) {
            return true;
        }
        if (pkValue instanceof String) {
            String pkValueStr = (String)pkValue;
            return pkValueStr.isEmpty();
        }
        return false;
    }

    public class VertexFlatPkKVPairs
    extends VertexKVPairs {
        private String pkName;
        private List<Object> pkValues;

        public VertexFlatPkKVPairs(VertexLabel vertexLabel) {
            super(vertexLabel);
        }

        @Override
        public void extractFromVertex(String[] names, Object[] values) {
            List primaryKeys = this.vertexLabel.primaryKeys();
            E.checkArgument((primaryKeys.size() == 1 ? 1 : 0) != 0, (String)"In case unfold is true, just supported a single primary key", (Object[])new Object[0]);
            this.pkName = (String)primaryKeys.get(0);
            this.properties = new HashMap();
            boolean handledPk = false;
            for (int i = 0; i < names.length; ++i) {
                String fieldName = names[i];
                Object fieldValue = values[i];
                if (!ElementBuilder.this.retainField(fieldName, fieldValue)) continue;
                String key = ElementBuilder.this.mapping().mappingField(fieldName);
                if (!handledPk && primaryKeys.contains(key)) {
                    List<Object> rawPkValues = this.splitField(fieldName, fieldValue);
                    this.pkValues = rawPkValues.stream().map(rawPkValue -> ElementBuilder.this.mappingValue(fieldName, rawPkValue)).collect(Collectors.toList());
                    handledPk = true;
                    continue;
                }
                Object value = ElementBuilder.this.mappingValue(fieldName, fieldValue);
                this.properties.put(key, value);
            }
        }

        @Override
        public void extractFromEdge(String[] names, Object[] values, int[] fieldIndexes) {
            List primaryKeys = this.vertexLabel.primaryKeys();
            E.checkArgument((fieldIndexes.length == 1 && primaryKeys.size() == 1 ? 1 : 0) != 0, (String)"In case unfold is true, just supported a single primary key", (Object[])new Object[0]);
            String fieldName = names[fieldIndexes[0]];
            this.pkName = ElementBuilder.this.mapping().mappingField(fieldName);
            String primaryKey = (String)primaryKeys.get(0);
            E.checkArgument((boolean)this.pkName.equals(primaryKey), (String)"Make sure the the primary key field '%s' is not empty, or check whether the headers or field_mapping are configured correctly", (Object[])new Object[]{primaryKey});
            Object fieldValue = values[fieldIndexes[0]];
            List<Object> rawPkValues = this.splitField(fieldName, fieldValue);
            this.pkValues = rawPkValues.stream().map(rawPkValue -> ElementBuilder.this.mappingValue(fieldName, rawPkValue)).collect(Collectors.toList());
        }

        @Override
        public List<Vertex> buildVertices(boolean withProperty) {
            E.checkArgument((this.pkValues != null ? 1 : 0) != 0, (String)"The primary values shouldn't be null", (Object[])new Object[0]);
            ArrayList<Vertex> vertices = new ArrayList<Vertex>(this.pkValues.size());
            for (Object pkValue : this.pkValues) {
                if (ElementBuilder.this.isEmptyPkValue(pkValue)) continue;
                pkValue = ElementBuilder.this.convertPropertyValue(this.pkName, pkValue);
                String id = ElementBuilder.this.spliceVertexId(this.vertexLabel, new Object[]{pkValue});
                ElementBuilder.this.checkVertexIdLength(id);
                Vertex vertex = new Vertex(this.vertexLabel.name());
                if (withProperty) {
                    ElementBuilder.this.addProperty((GraphElement)vertex, this.pkName, pkValue, false);
                    ElementBuilder.this.addProperties((GraphElement)vertex, this.properties);
                    ElementBuilder.this.checkNonNullableKeys((GraphElement)vertex);
                }
                vertex.id((Object)id);
                vertices.add(vertex);
            }
            return vertices;
        }
    }

    public class VertexPkKVPairs
    extends VertexKVPairs {
        private List<String> pkNames;
        private Object[] pkValues;

        public VertexPkKVPairs(VertexLabel vertexLabel) {
            super(vertexLabel);
        }

        @Override
        public void extractFromVertex(String[] names, Object[] values) {
            List primaryKeys;
            this.pkNames = primaryKeys = this.vertexLabel.primaryKeys();
            this.pkValues = new Object[primaryKeys.size()];
            this.properties = new HashMap();
            for (int i = 0; i < names.length; ++i) {
                String fieldName = names[i];
                Object fieldValue = values[i];
                if (!ElementBuilder.this.retainField(fieldName, fieldValue)) continue;
                String key = ElementBuilder.this.mapping().mappingField(fieldName);
                if (primaryKeys.contains(key)) {
                    Object pkValue;
                    int index = primaryKeys.indexOf(key);
                    this.pkValues[index] = pkValue = ElementBuilder.this.mappingValue(fieldName, fieldValue);
                    continue;
                }
                Object value = ElementBuilder.this.mappingValue(fieldName, fieldValue);
                this.properties.put(key, value);
            }
        }

        @Override
        public void extractFromEdge(String[] names, Object[] values, int[] fieldIndexes) {
            this.pkNames = new ArrayList<String>(fieldIndexes.length);
            for (int fieldIndex : fieldIndexes) {
                String fieldName = names[fieldIndex];
                String mappingField = ElementBuilder.this.mapping().mappingField(fieldName);
                this.pkNames.add(mappingField);
            }
            List primaryKeys = this.vertexLabel.primaryKeys();
            E.checkArgument((boolean)ListUtils.isEqualList(this.pkNames, (Collection)primaryKeys), (String)"Make sure the the primary key fields %s are not empty, or check whether the headers or field_mapping are configured correctly", (Object[])new Object[]{primaryKeys});
            this.pkValues = new Object[this.pkNames.size()];
            for (int i = 0; i < fieldIndexes.length; ++i) {
                Object pkValue;
                String fieldName = names[fieldIndexes[i]];
                Object fieldValue = values[fieldIndexes[i]];
                this.pkValues[i] = pkValue = ElementBuilder.this.mappingValue(fieldName, fieldValue);
            }
        }

        @Override
        public List<Vertex> buildVertices(boolean withProperty) {
            ElementBuilder.this.checkPrimaryValuesValid(this.vertexLabel, this.pkValues);
            for (int i = 0; i < this.pkNames.size(); ++i) {
                Object pkValue;
                if (ElementBuilder.this.isEmptyPkValue(this.pkValues[i])) {
                    return ImmutableList.of();
                }
                this.pkValues[i] = pkValue = ElementBuilder.this.convertPropertyValue(this.pkNames.get(i), this.pkValues[i]);
            }
            String id = ElementBuilder.this.spliceVertexId(this.vertexLabel, this.pkValues);
            ElementBuilder.this.checkVertexIdLength(id);
            Vertex vertex = new Vertex(this.vertexLabel.name());
            if (withProperty) {
                for (int i = 0; i < this.pkNames.size(); ++i) {
                    ElementBuilder.this.addProperty((GraphElement)vertex, this.pkNames.get(i), this.pkValues[i], false);
                }
                ElementBuilder.this.addProperties((GraphElement)vertex, this.properties);
                ElementBuilder.this.checkNonNullableKeys((GraphElement)vertex);
            }
            vertex.id((Object)id);
            return ImmutableList.of((Object)vertex);
        }
    }

    public class VertexFlatIdKVPairs
    extends VertexKVPairs {
        private String idField;
        private List<Object> idValues;

        public VertexFlatIdKVPairs(VertexLabel vertexLabel) {
            super(vertexLabel);
        }

        @Override
        public void extractFromVertex(String[] names, Object[] values) {
            this.properties = new HashMap();
            for (int i = 0; i < names.length; ++i) {
                String fieldName = names[i];
                Object fieldValue = values[i];
                if (!ElementBuilder.this.retainField(fieldName, fieldValue)) continue;
                if (ElementBuilder.this.isIdField(fieldName)) {
                    this.idField = fieldName;
                    List<Object> rawIdValues = this.splitField(fieldName, fieldValue);
                    this.idValues = rawIdValues.stream().map(rawIdValue -> ElementBuilder.this.mappingValue(fieldName, rawIdValue)).collect(Collectors.toList());
                    continue;
                }
                String key = ElementBuilder.this.mapping().mappingField(fieldName);
                Object value = ElementBuilder.this.mappingValue(fieldName, fieldValue);
                this.properties.put(key, value);
            }
        }

        @Override
        public void extractFromEdge(String[] names, Object[] values, int[] fieldIndexes) {
            assert (fieldIndexes.length == 1);
            String fieldName = names[fieldIndexes[0]];
            Object fieldValue = values[fieldIndexes[0]];
            this.idField = fieldName;
            List<Object> rawIdValues = this.splitField(fieldName, fieldValue);
            this.idValues = rawIdValues.stream().map(rawIdValue -> ElementBuilder.this.mappingValue(fieldName, rawIdValue)).collect(Collectors.toList());
        }

        @Override
        public List<Vertex> buildVertices(boolean withProperty) {
            ArrayList<Vertex> vertices = new ArrayList<Vertex>(this.idValues.size());
            for (Object idValue : this.idValues) {
                Vertex vertex = new Vertex(this.vertexLabel.name());
                ElementBuilder.this.customizeId(this.vertexLabel, vertex, this.idField, idValue);
                if (ElementBuilder.this.vertexIdEmpty(this.vertexLabel, vertex)) continue;
                if (withProperty) {
                    String key = ElementBuilder.this.mapping().mappingField(this.idField);
                    if (this.vertexLabel.properties().contains(key)) {
                        ElementBuilder.this.addProperty((GraphElement)vertex, key, idValue);
                    }
                    ElementBuilder.this.addProperties((GraphElement)vertex, this.properties);
                    ElementBuilder.this.checkNonNullableKeys((GraphElement)vertex);
                }
                vertices.add(vertex);
            }
            return vertices;
        }
    }

    public class VertexIdKVPairs
    extends VertexKVPairs {
        private String idField;
        private Object idValue;

        public VertexIdKVPairs(VertexLabel vertexLabel) {
            super(vertexLabel);
        }

        @Override
        public void extractFromVertex(String[] names, Object[] values) {
            this.properties = new HashMap();
            for (int i = 0; i < names.length; ++i) {
                String fieldName = names[i];
                Object fieldValue = values[i];
                if (!ElementBuilder.this.retainField(fieldName, fieldValue)) continue;
                if (ElementBuilder.this.isIdField(fieldName)) {
                    this.idField = fieldName;
                    this.idValue = ElementBuilder.this.mappingValue(fieldName, fieldValue);
                    continue;
                }
                String key = ElementBuilder.this.mapping().mappingField(fieldName);
                Object value = ElementBuilder.this.mappingValue(fieldName, fieldValue);
                this.properties.put(key, value);
            }
        }

        @Override
        public void extractFromEdge(String[] names, Object[] values, int[] fieldIndexes) {
            assert (fieldIndexes.length == 1);
            String fieldName = names[fieldIndexes[0]];
            Object fieldValue = values[fieldIndexes[0]];
            this.idField = fieldName;
            this.idValue = ElementBuilder.this.mappingValue(fieldName, fieldValue);
        }

        @Override
        public List<Vertex> buildVertices(boolean withProperty) {
            Vertex vertex = new Vertex(this.vertexLabel.name());
            ElementBuilder.this.customizeId(this.vertexLabel, vertex, this.idField, this.idValue);
            if (ElementBuilder.this.vertexIdEmpty(this.vertexLabel, vertex)) {
                return ImmutableList.of();
            }
            if (withProperty) {
                String key = ElementBuilder.this.mapping().mappingField(this.idField);
                if (this.vertexLabel.properties().contains(key)) {
                    ElementBuilder.this.addProperty((GraphElement)vertex, key, this.idValue);
                }
                ElementBuilder.this.addProperties((GraphElement)vertex, this.properties);
                ElementBuilder.this.checkNonNullableKeys((GraphElement)vertex);
            }
            return ImmutableList.of((Object)vertex);
        }
    }

    public abstract class VertexKVPairs {
        public final VertexLabel vertexLabel;
        public Map<String, Object> properties;

        public VertexKVPairs(VertexLabel vertexLabel) {
            this.vertexLabel = vertexLabel;
            this.properties = null;
        }

        public abstract void extractFromVertex(String[] var1, Object[] var2);

        public abstract void extractFromEdge(String[] var1, Object[] var2, int[] var3);

        public abstract List<Vertex> buildVertices(boolean var1);

        public List<Object> splitField(String key, Object value) {
            return DataTypeUtil.splitField(key, value, ElementBuilder.this.struct.input());
        }
    }
}

