/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.sorter;

import java.io.IOException;
import java.util.List;
import org.apache.hugegraph.computer.core.sort.sorter.InputsSorter;
import org.apache.hugegraph.computer.core.sort.sorting.InputsSorting;
import org.apache.hugegraph.computer.core.sort.sorting.SortingFactory;
import org.apache.hugegraph.computer.core.store.EntryIterator;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;

public class InputsSorterImpl
implements InputsSorter {
    @Override
    public EntryIterator sort(List<EntryIterator> entries) throws IOException {
        return new SortingEntries(entries);
    }

    private static class SortingEntries
    implements EntryIterator {
        private final InputsSorting<KvEntry> inputsSorting;
        private final List<EntryIterator> sources;
        private boolean closed;

        public SortingEntries(List<EntryIterator> sources) {
            this.sources = sources;
            this.inputsSorting = SortingFactory.createSorting(sources);
            this.closed = false;
        }

        public boolean hasNext() {
            return this.inputsSorting.hasNext();
        }

        public KvEntry next() {
            return (KvEntry)this.inputsSorting.next();
        }

        public void close() throws Exception {
            if (this.closed) {
                return;
            }
            for (EntryIterator source : this.sources) {
                source.close();
            }
            this.closed = true;
        }
    }
}

