/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hugegraph.computer.core.io.UnsafeBytesInput;
import org.apache.hugegraph.util.E;

public class BufferedStreamInput
extends UnsafeBytesInput {
    private final int bufferCapacity;
    private final InputStream input;
    private long inputOffset;

    public BufferedStreamInput(InputStream input) throws IOException {
        this(input, 8192);
    }

    public BufferedStreamInput(InputStream input, int bufferCapacity) throws IOException {
        super(new byte[bufferCapacity], 0);
        E.checkArgument((bufferCapacity >= 8 ? 1 : 0) != 0, (String)"The parameter bufferSize must be >= 8", (Object[])new Object[0]);
        this.input = input;
        this.bufferCapacity = bufferCapacity;
        this.shiftAndFillBuffer();
    }

    @Override
    public long position() {
        return this.inputOffset - (long)super.remaining();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len <= super.remaining()) {
            super.readFully(b, off, len);
        } else if (len <= this.bufferCapacity) {
            this.shiftAndFillBuffer();
            super.readFully(b, off, len);
        } else {
            int readLen;
            int remaining = super.remaining();
            super.readFully(b, off, remaining);
            for (int expectedLen = len - remaining; expectedLen > 0; expectedLen -= readLen) {
                readLen = this.input.read(b, off + remaining, expectedLen);
                if (readLen != -1) continue;
                throw new IOException("There is no enough data in input stream");
            }
            this.inputOffset += (long)len;
        }
    }

    @Override
    public void seek(long position) throws IOException {
        long bufferStart = this.inputOffset - (long)this.limit();
        if (position >= bufferStart && position < this.inputOffset) {
            super.seek(position - bufferStart);
            return;
        }
        if (position >= this.inputOffset) {
            int expectLen;
            int skipLen;
            this.inputOffset += (long)skipLen;
            byte[] buffer = this.buffer();
            for (skipLen = (int)(position - this.inputOffset); skipLen > 0; skipLen -= expectLen) {
                expectLen = Math.min(skipLen, this.bufferCapacity);
                int readLen = this.input.read(buffer, 0, expectLen);
                if (readLen != -1) continue;
                throw new IOException(String.format("Can't seek at position %s, reach the end of input stream", position));
            }
        } else {
            throw new IOException(String.format("The seek position %s underflows the start position %s of the buffer", position, this.inputOffset - (long)this.limit()));
        }
        super.seek(0L);
        super.limit(0);
        this.fillBuffer();
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        E.checkArgument((bytesToSkip >= 0L ? 1 : 0) != 0, (String)"The parameter bytesToSkip must be >= 0, but got %s", (Object[])new Object[]{bytesToSkip});
        long positionBeforeSkip = this.position();
        if (bytesToSkip <= (long)this.remaining()) {
            super.skip(bytesToSkip);
            return positionBeforeSkip;
        }
        long position = this.inputOffset + (bytesToSkip -= (long)this.remaining());
        this.seek(position);
        return positionBeforeSkip;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    protected void require(int size) throws IOException {
        if (this.remaining() >= size) {
            return;
        }
        this.shiftAndFillBuffer();
        if (size > this.limit()) {
            throw new IOException(String.format("Read %s bytes from position %s overflows buffer %s", size, this.position(), this.limit()));
        }
    }

    @Override
    public long available() throws IOException {
        return Long.MAX_VALUE;
    }

    private void shiftAndFillBuffer() throws IOException {
        this.shiftBuffer();
        this.fillBuffer();
    }

    private void fillBuffer() throws IOException {
        int expectLen = this.bufferCapacity - this.limit();
        int readLen = this.input.read(this.buffer(), this.limit(), expectLen);
        if (readLen > 0) {
            this.limit(this.limit() + readLen);
            this.inputOffset += (long)readLen;
        }
    }
}

