/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;

public final class ObservableZipIterable<T, U, V>
extends Observable<V> {
    final Observable<? extends T> source;
    final Iterable<U> other;
    final BiFunction<? super T, ? super U, ? extends V> zipper;

    public ObservableZipIterable(Observable<? extends T> source, Iterable<U> other, BiFunction<? super T, ? super U, ? extends V> zipper) {
        this.source = source;
        this.other = other;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(Observer<? super V> t) {
        boolean b;
        Iterator<U> it;
        try {
            it = ObjectHelper.requireNonNull(this.other.iterator(), "The iterator returned by other is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        try {
            b = it.hasNext();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        if (!b) {
            EmptyDisposable.complete(t);
            return;
        }
        this.source.subscribe(new ZipIterableObserver<T, U, V>(t, it, this.zipper));
    }

    static final class ZipIterableObserver<T, U, V>
    implements Observer<T>,
    Disposable {
        final Observer<? super V> downstream;
        final Iterator<U> iterator;
        final BiFunction<? super T, ? super U, ? extends V> zipper;
        Disposable upstream;
        boolean done;

        ZipIterableObserver(Observer<? super V> actual, Iterator<U> iterator, BiFunction<? super T, ? super U, ? extends V> zipper) {
            this.downstream = actual;
            this.iterator = iterator;
            this.zipper = zipper;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            boolean b;
            V v;
            U u;
            if (this.done) {
                return;
            }
            try {
                u = ObjectHelper.requireNonNull(this.iterator.next(), "The iterator returned a null value");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull(this.zipper.apply(t, u), "The zipper function returned a null value");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            this.downstream.onNext(v);
            try {
                b = this.iterator.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            if (!b) {
                this.done = true;
                this.upstream.dispose();
                this.downstream.onComplete();
            }
        }

        void error(Throwable e) {
            this.done = true;
            this.upstream.dispose();
            this.downstream.onError(e);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

