/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws.sqs.SqsUnboundedReader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

class SqsCheckpointMark
implements UnboundedSource.CheckpointMark,
Serializable {
    private transient @Nullable @UnknownKeyFor @Initialized SqsUnboundedReader reader;
    private @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> safeToDeleteIds;
    @VisibleForTesting
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> notYetReadReceipts;

    public SqsCheckpointMark(@UnknownKeyFor @NonNull @Initialized SqsUnboundedReader reader, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> messagesToDelete, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> notYetReadReceipts) {
        this.reader = reader;
        this.safeToDeleteIds = ImmutableList.copyOf(messagesToDelete);
        this.notYetReadReceipts = ImmutableList.copyOf(notYetReadReceipts);
    }

    public void finalizeCheckpoint() throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkState((this.reader != null && this.safeToDeleteIds != null ? 1 : 0) != 0, (Object)"Cannot finalize a restored checkpoint");
        try {
            this.reader.delete(this.safeToDeleteIds);
            int remainingInFlight = this.reader.numInFlightCheckpoints.decrementAndGet();
            Preconditions.checkState((remainingInFlight >= 0 ? 1 : 0) != 0, (Object)"Miscounted in-flight checkpoints");
        }
        catch (Throwable throwable) {
            int remainingInFlight = this.reader.numInFlightCheckpoints.decrementAndGet();
            Preconditions.checkState((remainingInFlight >= 0 ? 1 : 0) != 0, (Object)"Miscounted in-flight checkpoints");
            this.reader.maybeCloseClient();
            this.reader = null;
            this.safeToDeleteIds = null;
            throw throwable;
        }
        this.reader.maybeCloseClient();
        this.reader = null;
        this.safeToDeleteIds = null;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqsCheckpointMark that = (SqsCheckpointMark)o;
        return Objects.equal(this.safeToDeleteIds, that.safeToDeleteIds);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.safeToDeleteIds});
    }
}

