/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sns;

import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.SdkHttpMetadata;
import com.amazonaws.services.sns.model.PublishResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.aws.coders.AwsCoders;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class PublishResultCoders {
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> MESSAGE_ID_CODER = StringUtf8Coder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ResponseMetadata> RESPONSE_METADATA_CODER = NullableCoder.of(AwsCoders.responseMetadata());

    private PublishResultCoders() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized PublishResult> defaultPublishResult() {
        return new PublishResultCoder(null, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized PublishResult> fullPublishResult() {
        return new PublishResultCoder(RESPONSE_METADATA_CODER, (Coder)NullableCoder.of(AwsCoders.sdkHttpMetadata()));
    }

    public static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized PublishResult> fullPublishResultWithoutHeaders() {
        return new PublishResultCoder(RESPONSE_METADATA_CODER, (Coder)NullableCoder.of(AwsCoders.sdkHttpMetadataWithoutHeaders()));
    }

    static class PublishResultCoder
    extends CustomCoder<PublishResult> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ResponseMetadata> responseMetadataEncoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized SdkHttpMetadata> sdkHttpMetadataCoder;

        private PublishResultCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ResponseMetadata> responseMetadataEncoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized SdkHttpMetadata> sdkHttpMetadataCoder) {
            this.responseMetadataEncoder = responseMetadataEncoder;
            this.sdkHttpMetadataCoder = sdkHttpMetadataCoder;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized PublishResult value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            MESSAGE_ID_CODER.encode((Object)value.getMessageId(), outStream);
            if (this.responseMetadataEncoder != null) {
                this.responseMetadataEncoder.encode((Object)value.getSdkResponseMetadata(), outStream);
            }
            if (this.sdkHttpMetadataCoder != null) {
                this.sdkHttpMetadataCoder.encode((Object)value.getSdkHttpMetadata(), outStream);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized PublishResult decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            String messageId = (String)MESSAGE_ID_CODER.decode(inStream);
            PublishResult publishResult = new PublishResult().withMessageId(messageId);
            if (this.responseMetadataEncoder != null) {
                publishResult.setSdkResponseMetadata((ResponseMetadata)this.responseMetadataEncoder.decode(inStream));
            }
            if (this.sdkHttpMetadataCoder != null) {
                publishResult.setSdkHttpMetadata((SdkHttpMetadata)this.sdkHttpMetadataCoder.decode(inStream));
            }
            return publishResult;
        }

        public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            MESSAGE_ID_CODER.verifyDeterministic();
            if (this.responseMetadataEncoder != null) {
                this.responseMetadataEncoder.verifyDeterministic();
            }
            if (this.sdkHttpMetadataCoder != null) {
                this.sdkHttpMetadataCoder.verifyDeterministic();
            }
        }
    }
}

