/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.aws.s3.S3FileSystemConfiguration;
import org.apache.beam.sdk.io.aws.s3.S3ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethodsIf;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class S3WritableByteChannel
implements WritableByteChannel {
    private final @UnknownKeyFor @NonNull @Initialized AmazonS3 amazonS3;
    private final @UnknownKeyFor @NonNull @Initialized S3FileSystemConfiguration config;
    private final @UnknownKeyFor @NonNull @Initialized S3ResourceId path;
    private final @UnknownKeyFor @NonNull @Initialized String uploadId;
    private final @UnknownKeyFor @NonNull @Initialized ByteBuffer uploadBuffer;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartETag> eTags;
    private @UnknownKeyFor @NonNull @Initialized int partNumber = 1;
    private @UnknownKeyFor @NonNull @Initialized boolean open = true;
    private final @UnknownKeyFor @NonNull @Initialized MessageDigest md5 = S3WritableByteChannel.md5();

    S3WritableByteChannel(@UnknownKeyFor @NonNull @Initialized AmazonS3 amazonS3, @UnknownKeyFor @NonNull @Initialized S3ResourceId path, @UnknownKeyFor @NonNull @Initialized String contentType, @UnknownKeyFor @NonNull @Initialized S3FileSystemConfiguration config) throws @UnknownKeyFor @NonNull @Initialized IOException {
        InitiateMultipartUploadResult result;
        this.amazonS3 = (AmazonS3)Preconditions.checkNotNull((Object)amazonS3, (Object)"amazonS3");
        this.config = (S3FileSystemConfiguration)Preconditions.checkNotNull((Object)config);
        this.path = (S3ResourceId)Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkArgument((boolean)S3WritableByteChannel.atMostOne(config.getSSECustomerKey() != null, config.getSSEAlgorithm() != null, config.getSSEAwsKeyManagementParams() != null), (Object)"Either SSECustomerKey (SSE-C) or SSEAlgorithm (SSE-S3) or SSEAwsKeyManagementParams (SSE-KMS) must not be set at the same time.");
        Preconditions.checkArgument((config.getS3UploadBufferSizeBytes() >= 0x500000 ? 1 : 0) != 0, (String)"S3UploadBufferSizeBytes must be at least %s bytes", (int)0x500000);
        this.uploadBuffer = ByteBuffer.allocate(config.getS3UploadBufferSizeBytes());
        this.eTags = new ArrayList<PartETag>();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(contentType);
        if (config.getSSEAlgorithm() != null) {
            objectMetadata.setSSEAlgorithm(config.getSSEAlgorithm());
        }
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(path.getBucket(), path.getKey()).withStorageClass(config.getS3StorageClass()).withObjectMetadata(objectMetadata);
        request.setSSECustomerKey(config.getSSECustomerKey());
        request.setSSEAwsKeyManagementParams(config.getSSEAwsKeyManagementParams());
        request.setBucketKeyEnabled(Boolean.valueOf(config.getBucketKeyEnabled()));
        try {
            result = amazonS3.initiateMultipartUpload(request);
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        this.uploadId = result.getUploadId();
    }

    private static @UnknownKeyFor @NonNull @Initialized MessageDigest md5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int write(@UnknownKeyFor @NonNull @Initialized ByteBuffer sourceBuffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int totalBytesWritten = 0;
        while (sourceBuffer.hasRemaining()) {
            int position = sourceBuffer.position();
            int bytesWritten = Math.min(sourceBuffer.remaining(), this.uploadBuffer.remaining());
            totalBytesWritten += bytesWritten;
            if (sourceBuffer.hasArray()) {
                int start = sourceBuffer.arrayOffset() + position;
                this.uploadBuffer.put(sourceBuffer.array(), start, bytesWritten);
                this.md5.update(sourceBuffer.array(), start, bytesWritten);
            } else {
                ByteBuffer copyBuffer = sourceBuffer.asReadOnlyBuffer();
                copyBuffer.mark().limit(position + bytesWritten);
                this.uploadBuffer.put(copyBuffer);
                copyBuffer.reset();
                this.md5.update(copyBuffer);
            }
            sourceBuffer.position(position + bytesWritten);
            if (this.uploadBuffer.hasRemaining() && !sourceBuffer.hasRemaining()) continue;
            this.flush();
        }
        return totalBytesWritten;
    }

    private void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        UploadPartResult result;
        this.uploadBuffer.flip();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.uploadBuffer.array(), 0, this.uploadBuffer.limit());
        UploadPartRequest request = new UploadPartRequest().withBucketName(this.path.getBucket()).withKey(this.path.getKey()).withUploadId(this.uploadId).withPartNumber(this.partNumber++).withPartSize((long)this.uploadBuffer.limit()).withMD5Digest(Base64.encodeAsString((byte[])this.md5.digest())).withInputStream((InputStream)inputStream);
        request.setSSECustomerKey(this.config.getSSECustomerKey());
        try {
            result = this.amazonS3.uploadPart(request);
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        this.uploadBuffer.clear();
        this.md5.reset();
        this.eTags.add(result.getPartETag());
    }

    @Override
    @EnsuresCalledMethodsIf(expression={"this"}, result=false, methods={"close"})
    public @UnknownKeyFor @NonNull @Initialized boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.open = false;
        if (this.uploadBuffer.remaining() > 0) {
            this.flush();
        }
        CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest().withBucketName(this.path.getBucket()).withKey(this.path.getKey()).withUploadId(this.uploadId).withPartETags(this.eTags);
        try {
            this.amazonS3.completeMultipartUpload(request);
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized boolean atMostOne(boolean ... values) {
        boolean one = false;
        for (boolean value : values) {
            if (!one && value) {
                one = true;
                continue;
            }
            if (!value) continue;
            return false;
        }
        return true;
    }
}

