/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.shuffle.protocol.BlockPushReturnCode;
import org.apache.spark.network.shuffle.protocol.BlocksRemoved;
import org.apache.spark.network.shuffle.protocol.CorruptionCause;
import org.apache.spark.network.shuffle.protocol.DiagnoseCorruption;
import org.apache.spark.network.shuffle.protocol.FetchShuffleBlockChunks;
import org.apache.spark.network.shuffle.protocol.FetchShuffleBlocks;
import org.apache.spark.network.shuffle.protocol.FinalizeShuffleMerge;
import org.apache.spark.network.shuffle.protocol.GetLocalDirsForExecutors;
import org.apache.spark.network.shuffle.protocol.LocalDirsForExecutors;
import org.apache.spark.network.shuffle.protocol.MergeStatuses;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.PushBlockStream;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.shuffle.protocol.RemoveBlocks;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.network.shuffle.protocol.mesos.RegisterDriver;
import org.apache.spark.network.shuffle.protocol.mesos.ShuffleServiceHeartbeat;

public abstract class BlockTransferMessage
implements Encodable {
    protected abstract Type type();

    public ByteBuffer toByteBuffer() {
        ByteBuf buf = Unpooled.buffer((int)(this.encodedLength() + 1));
        buf.writeByte((int)this.type().id);
        this.encode(buf);
        assert (buf.writableBytes() == 0) : "Writable bytes remain: " + buf.writableBytes();
        return buf.nioBuffer();
    }

    public static class Decoder {
        public static BlockTransferMessage fromByteBuffer(ByteBuffer msg) {
            ByteBuf buf = Unpooled.wrappedBuffer((ByteBuffer)msg);
            byte type = buf.readByte();
            switch (type) {
                case 0: {
                    return OpenBlocks.decode(buf);
                }
                case 1: {
                    return UploadBlock.decode(buf);
                }
                case 2: {
                    return RegisterExecutor.decode(buf);
                }
                case 3: {
                    return StreamHandle.decode(buf);
                }
                case 4: {
                    return RegisterDriver.decode(buf);
                }
                case 5: {
                    return ShuffleServiceHeartbeat.decode(buf);
                }
                case 6: {
                    return UploadBlockStream.decode(buf);
                }
                case 7: {
                    return RemoveBlocks.decode(buf);
                }
                case 8: {
                    return BlocksRemoved.decode(buf);
                }
                case 9: {
                    return FetchShuffleBlocks.decode(buf);
                }
                case 10: {
                    return GetLocalDirsForExecutors.decode(buf);
                }
                case 11: {
                    return LocalDirsForExecutors.decode(buf);
                }
                case 12: {
                    return PushBlockStream.decode(buf);
                }
                case 13: {
                    return FinalizeShuffleMerge.decode(buf);
                }
                case 14: {
                    return MergeStatuses.decode(buf);
                }
                case 15: {
                    return FetchShuffleBlockChunks.decode(buf);
                }
                case 16: {
                    return DiagnoseCorruption.decode(buf);
                }
                case 17: {
                    return CorruptionCause.decode(buf);
                }
                case 18: {
                    return BlockPushReturnCode.decode(buf);
                }
            }
            throw new IllegalArgumentException("Unknown message type: " + type);
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type OPEN_BLOCKS = new Type(0);
        public static final /* enum */ Type UPLOAD_BLOCK = new Type(1);
        public static final /* enum */ Type REGISTER_EXECUTOR = new Type(2);
        public static final /* enum */ Type STREAM_HANDLE = new Type(3);
        public static final /* enum */ Type REGISTER_DRIVER = new Type(4);
        public static final /* enum */ Type HEARTBEAT = new Type(5);
        public static final /* enum */ Type UPLOAD_BLOCK_STREAM = new Type(6);
        public static final /* enum */ Type REMOVE_BLOCKS = new Type(7);
        public static final /* enum */ Type BLOCKS_REMOVED = new Type(8);
        public static final /* enum */ Type FETCH_SHUFFLE_BLOCKS = new Type(9);
        public static final /* enum */ Type GET_LOCAL_DIRS_FOR_EXECUTORS = new Type(10);
        public static final /* enum */ Type LOCAL_DIRS_FOR_EXECUTORS = new Type(11);
        public static final /* enum */ Type PUSH_BLOCK_STREAM = new Type(12);
        public static final /* enum */ Type FINALIZE_SHUFFLE_MERGE = new Type(13);
        public static final /* enum */ Type MERGE_STATUSES = new Type(14);
        public static final /* enum */ Type FETCH_SHUFFLE_BLOCK_CHUNKS = new Type(15);
        public static final /* enum */ Type DIAGNOSE_CORRUPTION = new Type(16);
        public static final /* enum */ Type CORRUPTION_CAUSE = new Type(17);
        public static final /* enum */ Type PUSH_BLOCK_RETURN_CODE = new Type(18);
        private final byte id;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id) {
            assert (id < 128) : "Cannot have more than 128 message types";
            this.id = (byte)id;
        }

        public byte id() {
            return this.id;
        }

        static {
            $VALUES = new Type[]{OPEN_BLOCKS, UPLOAD_BLOCK, REGISTER_EXECUTOR, STREAM_HANDLE, REGISTER_DRIVER, HEARTBEAT, UPLOAD_BLOCK_STREAM, REMOVE_BLOCKS, BLOCKS_REMOVED, FETCH_SHUFFLE_BLOCKS, GET_LOCAL_DIRS_FOR_EXECUTORS, LOCAL_DIRS_FOR_EXECUTORS, PUSH_BLOCK_STREAM, FINALIZE_SHUFFLE_MERGE, MERGE_STATUSES, FETCH_SHUFFLE_BLOCK_CHUNKS, DIAGNOSE_CORRUPTION, CORRUPTION_CAUSE, PUSH_BLOCK_RETURN_CODE};
        }
    }
}

