/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

public class TimestampedValue<@UnknownKeyFor V> {
    private final V value;
    private final @UnknownKeyFor @NonNull @Initialized Instant timestamp;

    public static <V> @UnknownKeyFor @NonNull @Initialized TimestampedValue<V> atMinimumTimestamp(V value) {
        return TimestampedValue.of(value, BoundedWindow.TIMESTAMP_MIN_VALUE);
    }

    public static <V> @UnknownKeyFor @NonNull @Initialized TimestampedValue<V> of(V value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        return new TimestampedValue<V>(value, timestamp);
    }

    public V getValue() {
        return this.value;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
        return this.timestamp;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (!(other instanceof TimestampedValue)) {
            return false;
        }
        TimestampedValue that = (TimestampedValue)other;
        return Objects.equals(this.value, that.value) && Objects.equals(this.timestamp, that.timestamp);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.value, this.timestamp);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "TimestampedValue(" + this.value + ", " + this.timestamp + ")";
    }

    protected TimestampedValue(V value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp must be non-null");
        this.value = value;
        this.timestamp = timestamp;
    }

    public static class TimestampedValueCoder<@UnknownKeyFor T>
    extends StructuredCoder<TimestampedValue<T>> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder;

        public static <T> @UnknownKeyFor @NonNull @Initialized TimestampedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            return new TimestampedValueCoder<T>(valueCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized TimestampedValue<T> value) {
            Object structuralValue = this.valueCoder.structuralValue(value.getValue());
            return TimestampedValue.of(structuralValue, value.getTimestamp());
        }

        TimestampedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            this.valueCoder = (Coder)Preconditions.checkNotNull(valueCoder);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized TimestampedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.valueCoder.encode(windowedElem.getValue(), outStream);
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TimestampedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            T value = this.valueCoder.decode(inStream);
            Instant timestamp = InstantCoder.of().decode(inStream);
            return TimestampedValue.of(value, timestamp);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            TimestampedValueCoder.verifyDeterministic(this, "TimestampedValueCoder requires a deterministic valueCoder", this.valueCoder);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Arrays.asList(this.valueCoder);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<T> getValueCoder() {
            return this.valueCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> getEncodedTypeDescriptor() {
            return new TypeDescriptor<TimestampedValue<T>>(){}.where(new TypeParameter<T>(){}, this.valueCoder.getEncodedTypeDescriptor());
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getComponents() {
            return Collections.singletonList(this.valueCoder);
        }
    }
}

