/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@NotThreadSafe
public class BufferedElementCountingOutputStream
extends OutputStream {
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_POOLED = 12;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized ArrayBlockingQueue<@UnknownKeyFor @NonNull @Initialized ByteBuffer> BUFFER_POOL = new ArrayBlockingQueue(12);
    public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BUFFER_SIZE = 65536;
    private final @UnknownKeyFor @NonNull @Initialized ByteBuffer buffer;
    private final @UnknownKeyFor @NonNull @Initialized OutputStream os;
    private final @UnknownKeyFor @NonNull @Initialized long terminatorValue;
    private @UnknownKeyFor @NonNull @Initialized boolean finished;
    private @UnknownKeyFor @NonNull @Initialized long count;

    public BufferedElementCountingOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream os) {
        this(os, 65536, 0L);
    }

    public BufferedElementCountingOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream os, @UnknownKeyFor @NonNull @Initialized long terminatorValue) {
        this(os, 65536, terminatorValue);
    }

    BufferedElementCountingOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream os, @UnknownKeyFor @NonNull @Initialized int bufferSize, @UnknownKeyFor @NonNull @Initialized long terminatorValue) {
        this.os = os;
        this.terminatorValue = terminatorValue;
        this.finished = false;
        this.count = 0L;
        ByteBuffer buffer = BUFFER_POOL.poll();
        if (buffer == null) {
            buffer = ByteBuffer.allocate(bufferSize);
        }
        this.buffer = buffer;
    }

    public void finish() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.finished) {
            return;
        }
        this.flush();
        VarInt.encode(this.terminatorValue, this.os);
        if (!BUFFER_POOL.offer(this.buffer)) {
            // empty if block
        }
        this.finished = true;
    }

    public void markElementStart() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.finished) {
            throw new IOException("Stream has been finished. Can not add any more elements.");
        }
        ++this.count;
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int b) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.finished) {
            throw new IOException("Stream has been finished. Can not write any more data.");
        }
        if (this.count == 0L) {
            this.os.write(b);
            return;
        }
        if (this.buffer.hasRemaining()) {
            this.buffer.put((byte)b);
        } else {
            this.outputBuffer();
            this.os.write(b);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.finished) {
            throw new IOException("Stream has been finished. Can not write any more data.");
        }
        if (this.count == 0L) {
            this.os.write(b, off, len);
            return;
        }
        if (this.buffer.remaining() >= len) {
            this.buffer.put(b, off, len);
        } else {
            this.outputBuffer();
            this.os.write(b, off, len);
        }
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.finished) {
            return;
        }
        this.outputBuffer();
        this.os.flush();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.finish();
        this.os.close();
    }

    private void outputBuffer() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.count > 0L) {
            VarInt.encode(this.count, this.os);
            this.os.write(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position());
            this.buffer.clear();
            this.count = 0L;
        }
    }
}

