/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.transforms.splittabledofn.AutoValue_RestrictionTracker_Progress;
import org.apache.beam.sdk.transforms.splittabledofn.AutoValue_RestrictionTracker_TruncateResult;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class RestrictionTracker<@UnknownKeyFor RestrictionT, @UnknownKeyFor PositionT> {
    public abstract @UnknownKeyFor @NonNull @Initialized boolean tryClaim(PositionT var1);

    public abstract RestrictionT currentRestriction();

    public abstract @Nullable @UnknownKeyFor @Initialized SplitResult<RestrictionT> trySplit(@UnknownKeyFor @NonNull @Initialized double var1);

    public abstract void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException;

    public abstract @UnknownKeyFor @NonNull @Initialized IsBounded isBounded();

    @AutoValue
    public static abstract class TruncateResult<@UnknownKeyFor RestrictionT> {
        public static <RestrictionT> @UnknownKeyFor @NonNull @Initialized TruncateResult of(RestrictionT restriction) {
            return new AutoValue_RestrictionTracker_TruncateResult<RestrictionT>(restriction);
        }

        public abstract @Nullable RestrictionT getTruncatedRestriction();
    }

    @AutoValue
    public static abstract class Progress {
        public static @UnknownKeyFor @NonNull @Initialized Progress from(@UnknownKeyFor @NonNull @Initialized double workCompleted, @UnknownKeyFor @NonNull @Initialized double workRemaining) {
            if (workCompleted < 0.0 || workRemaining < 0.0) {
                throw new IllegalArgumentException(String.format("Work completed and work remaining must be greater than or equal to zero but were %s and %s.", workCompleted, workRemaining));
            }
            return new AutoValue_RestrictionTracker_Progress(workCompleted, workRemaining);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized double getWorkCompleted();

        public abstract @UnknownKeyFor @NonNull @Initialized double getWorkRemaining();
    }

    public static interface HasProgress {
        public @UnknownKeyFor @NonNull @Initialized Progress getProgress();
    }

    public static enum IsBounded {
        BOUNDED,
        UNBOUNDED;

    }
}

