/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class VariableString
extends PassThroughLogicalType<String> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = (String)SchemaApi.LogicalTypes.Enum.VAR_CHAR.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    private final @Nullable @UnknownKeyFor @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized int maxStringLength;

    public static @UnknownKeyFor @NonNull @Initialized VariableString of(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized int maxStringLength) {
        return new VariableString(name, maxStringLength);
    }

    public static @UnknownKeyFor @NonNull @Initialized VariableString of(@UnknownKeyFor @NonNull @Initialized int maxStringLength) {
        return VariableString.of(null, maxStringLength);
    }

    private VariableString(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized int maxStringLength) {
        super(IDENTIFIER, Schema.FieldType.INT32, maxStringLength, Schema.FieldType.STRING);
        this.name = name;
        this.maxStringLength = maxStringLength;
    }

    public @UnknownKeyFor @NonNull @Initialized int getMaxLength() {
        return this.maxStringLength;
    }

    public @Nullable @UnknownKeyFor @Initialized String getName() {
        return this.name;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String toInputType(@UnknownKeyFor @NonNull @Initialized String base) {
        Preconditions.checkArgument((base.length() <= this.maxStringLength ? 1 : 0) != 0);
        return base;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "VariableString: " + this.maxStringLength;
    }
}

