/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.util.Arrays;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class FixedBytes
extends PassThroughLogicalType<byte[]> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = (String)SchemaApi.LogicalTypes.Enum.FIXED_BYTES.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    private final @Nullable @UnknownKeyFor @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized int byteArrayLength;

    public static @UnknownKeyFor @NonNull @Initialized FixedBytes of(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized int byteArrayLength) {
        return new FixedBytes(name, byteArrayLength);
    }

    public static @UnknownKeyFor @NonNull @Initialized FixedBytes of(@UnknownKeyFor @NonNull @Initialized int byteArrayLength) {
        return FixedBytes.of(null, byteArrayLength);
    }

    private FixedBytes(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized int byteArrayLength) {
        super(IDENTIFIER, Schema.FieldType.INT32, byteArrayLength, Schema.FieldType.BYTES);
        this.name = name;
        this.byteArrayLength = byteArrayLength;
    }

    public @UnknownKeyFor @NonNull @Initialized int getLength() {
        return this.byteArrayLength;
    }

    public @Nullable @UnknownKeyFor @Initialized String getName() {
        return this.name;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toBaseType(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
        Preconditions.checkArgument((input.length == this.byteArrayLength ? 1 : 0) != 0);
        return input;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toInputType(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] base) {
        Preconditions.checkArgument((base.length <= this.byteArrayLength ? 1 : 0) != 0);
        if (base.length == this.byteArrayLength) {
            return base;
        }
        return Arrays.copyOf(base, this.byteArrayLength);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "FixedBytes: " + this.byteArrayLength;
    }
}

