/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptionSpec;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsReflector;
import org.apache.beam.sdk.options.PipelineOptionsRegistrar;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.options.ProxyInvocationHandler;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.PipelineRunnerRegistrar;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSortedSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Ordering;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.SortedSetMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.TreeBasedTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.TreeMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineOptionsFactory {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> SIMPLE_TYPES = ImmutableSet.builder().add(Boolean.TYPE).add(Boolean.class).add(Character.TYPE).add(Character.class).add(Short.TYPE).add(Short.class).add(Integer.TYPE).add(Integer.class).add(Long.TYPE).add(Long.class).add(Float.TYPE).add(Float.class).add(Double.TYPE).add(Double.class).add(String.class).add(Class.class).build();
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PipelineOptionsFactory.class);
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> @UnknownKeyFor @NonNull @Initialized [] EMPTY_CLASS_ARRAY = new Class[0];
    static final @UnknownKeyFor @NonNull @Initialized ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    private static final @UnknownKeyFor @NonNull @Initialized ThreadLocal<@UnknownKeyFor @NonNull @Initialized DefaultDeserializationContext> DESERIALIZATION_CONTEXT = ThreadLocal.withInitial(() -> new DefaultDeserializationContext.Impl(MAPPER.getDeserializationContext().getFactory()).createInstance(MAPPER.getDeserializationConfig(), new TokenBuffer((ObjectCodec)MAPPER, false).asParser(), (InjectableValues)new InjectableValues.Std()));
    static final @UnknownKeyFor @NonNull @Initialized DefaultSerializerProvider SERIALIZER_PROVIDER = new DefaultSerializerProvider.Impl().createInstance(MAPPER.getSerializationConfig(), MAPPER.getSerializerFactory());
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> PIPELINE_OPTIONS_FACTORY_CLASSES = ImmutableSet.of((Object)PipelineOptionsFactory.class.getName(), (Object)Builder.class.getName());
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Method> IGNORED_METHODS;
    static final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Cache> CACHE;
    private static final @UnknownKeyFor @NonNull @Initialized int TERMINAL_WIDTH = 80;
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> JSON_INTEGER_TYPES;
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> JSON_NUMBER_TYPES;

    public static @UnknownKeyFor @NonNull @Initialized PipelineOptions create() {
        return new Builder().as(PipelineOptions.class);
    }

    public static <T extends PipelineOptions> T as(@UnknownKeyFor @NonNull @Initialized Class<T> klass) {
        return new Builder().as(klass);
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder fromArgs(String ... args) {
        return new Builder().fromArgs(args);
    }

    public @UnknownKeyFor @NonNull @Initialized Builder withValidation() {
        return new Builder().withValidation();
    }

    static @UnknownKeyFor @NonNull @Initialized boolean printHelpUsageAndExitIfNeeded(@UnknownKeyFor @NonNull @Initialized ListMultimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> options, @UnknownKeyFor @NonNull @Initialized PrintStream printStream, @UnknownKeyFor @NonNull @Initialized boolean exit) {
        if (options.containsKey((Object)"help")) {
            String helpOption = (String)Iterables.getOnlyElement((Iterable)options.get((Object)"help"));
            if (Boolean.TRUE.toString().equals(helpOption)) {
                PipelineOptionsFactory.printHelp(printStream);
                if (exit) {
                    System.exit(0);
                } else {
                    return true;
                }
            }
            try {
                Class<?> klass = Class.forName(helpOption, true, ReflectHelpers.findClassLoader());
                if (!PipelineOptions.class.isAssignableFrom(klass)) {
                    throw new ClassNotFoundException("PipelineOptions of type " + klass + " not found.");
                }
                PipelineOptionsFactory.printHelp(printStream, klass);
            }
            catch (ClassNotFoundException e) {
                Iterable matches = PipelineOptionsFactory.getRegisteredOptions().stream().filter(input -> {
                    if (helpOption.contains(".")) {
                        return input.getName().endsWith(helpOption);
                    }
                    return input.getSimpleName().equals(helpOption);
                }).collect(Collectors.toList());
                try {
                    PipelineOptionsFactory.printHelp(printStream, (Class)Iterables.getOnlyElement((Iterable)matches));
                }
                catch (NoSuchElementException exception) {
                    printStream.format("Unable to find option %s.%n", helpOption);
                    PipelineOptionsFactory.printHelp(printStream);
                }
                catch (IllegalArgumentException exception) {
                    printStream.format("Multiple matches found for %s: %s.%n", helpOption, StreamSupport.stream(matches.spliterator(), false).map(Class::getName).collect(Collectors.toList()));
                    PipelineOptionsFactory.printHelp(printStream);
                }
            }
            if (exit) {
                System.exit(0);
            } else {
                return true;
            }
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized String findCallersClassName() {
        StackTraceElement next;
        UnmodifiableIterator elements = Iterators.forArray((Object[])Thread.currentThread().getStackTrace());
        while (elements.hasNext() && !PIPELINE_OPTIONS_FACTORY_CLASSES.contains((Object)(next = (StackTraceElement)elements.next()).getClassName())) {
        }
        while (elements.hasNext()) {
            next = (StackTraceElement)elements.next();
            if (PIPELINE_OPTIONS_FACTORY_CLASSES.contains((Object)next.getClassName())) continue;
            try {
                return Class.forName(next.getClassName(), true, ReflectHelpers.findClassLoader()).getSimpleName();
            }
            catch (ClassNotFoundException e) {
                break;
            }
        }
        return "unknown";
    }

    public static synchronized void register(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> iface) {
        PipelineOptionsFactory.CACHE.get().register(iface);
    }

    @Experimental
    public static synchronized void resetCache() {
        CACHE.set(new Cache());
    }

    public static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> getRegisteredOptions() {
        return Collections.unmodifiableSet(CACHE.get().registeredOptions);
    }

    public static void printHelp(@UnknownKeyFor @NonNull @Initialized PrintStream out) {
        Preconditions.checkNotNull((Object)out);
        out.println("The set of registered options are:");
        TreeSet sortedOptions = new TreeSet(ClassNameComparator.INSTANCE);
        sortedOptions.addAll(CACHE.get().registeredOptions);
        for (Class kls : sortedOptions) {
            out.format("  %s%n", kls.getName());
        }
        out.format("%nUse --help=<OptionsName> for detailed help. For example:%n  --help=DataflowPipelineOptions <short names valid for registered options>%n  --help=org.apache.beam.runners.dataflow.options.DataflowPipelineOptions%n", new Object[0]);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void printHelp(@UnknownKeyFor @NonNull @Initialized PrintStream out, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> iface) {
        Preconditions.checkNotNull((Object)out);
        Preconditions.checkNotNull(iface);
        PipelineOptionsFactory.CACHE.get().validateWellFormed(iface);
        Set<PipelineOptionSpec> properties = PipelineOptionsReflector.getOptionSpecs(iface, true);
        TreeBasedTable ifacePropGetterTable = TreeBasedTable.create((Comparator)ClassNameComparator.INSTANCE, (Comparator)Ordering.natural());
        for (PipelineOptionSpec pipelineOptionSpec : properties) {
            ifacePropGetterTable.put(pipelineOptionSpec.getDefiningInterface(), (Object)pipelineOptionSpec.getName(), (Object)pipelineOptionSpec.getGetterMethod());
        }
        for (Map.Entry entry : ifacePropGetterTable.rowMap().entrySet()) {
            Class currentIface = (Class)entry.getKey();
            Map propertyNamesToGetters = (Map)entry.getValue();
            SortedSetMultimap<String, String> requiredGroupNameToProperties = PipelineOptionsFactory.getRequiredGroupNamesToProperties(propertyNamesToGetters);
            out.format("%s:%n", currentIface.getName());
            Description ifaceDescription = currentIface.getAnnotation(Description.class);
            if (ifaceDescription != null && ifaceDescription.value() != null) {
                PipelineOptionsFactory.prettyPrintDescription(out, ifaceDescription);
            }
            out.println();
            @KeyFor(value={"propertyNamesToGetters"}) ArrayList lists = Lists.newArrayList(propertyNamesToGetters.keySet());
            lists.sort(String.CASE_INSENSITIVE_ORDER);
            for (String propertyName : lists) {
                Description methodDescription;
                Method method = (Method)propertyNamesToGetters.get(propertyName);
                String printableType = method.getReturnType().getSimpleName();
                if (method.getReturnType().isEnum()) {
                    ? @Nullable [] enumConstants = method.getReturnType().getEnumConstants();
                    assert (enumConstants != null) : "@AssumeAssertion(nullness): checked that it is an enum";
                    printableType = Joiner.on((String)" | ").join((Object[])method.getReturnType().getEnumConstants());
                }
                out.format("  --%s=<%s>%n", propertyName, printableType);
                Optional<String> defaultValue = PipelineOptionsFactory.getDefaultValueFromAnnotation(method);
                if (defaultValue.isPresent()) {
                    out.format("    Default: %s%n", defaultValue.get());
                }
                if ((methodDescription = method.getAnnotation(Description.class)) != null && methodDescription.value() != null) {
                    PipelineOptionsFactory.prettyPrintDescription(out, methodDescription);
                }
                PipelineOptionsFactory.prettyPrintRequiredGroups(out, method.getAnnotation(Validation.Required.class), requiredGroupNameToProperties);
            }
            out.println();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized JobApi.PipelineOptionDescriptor> describe(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> ifaces) {
        Preconditions.checkNotNull(ifaces);
        ArrayList<JobApi.PipelineOptionDescriptor> result = new ArrayList<JobApi.PipelineOptionDescriptor>();
        HashSet seenMethods = Sets.newHashSet();
        for (Class<? extends PipelineOptions> iface : ifaces) {
            PipelineOptionsFactory.CACHE.get().validateWellFormed(iface);
            Set<PipelineOptionSpec> properties = PipelineOptionsReflector.getOptionSpecs(iface, false);
            TreeBasedTable ifacePropGetterTable = TreeBasedTable.create((Comparator)ClassNameComparator.INSTANCE, (Comparator)Ordering.natural());
            for (PipelineOptionSpec pipelineOptionSpec : properties) {
                ifacePropGetterTable.put(pipelineOptionSpec.getDefiningInterface(), (Object)pipelineOptionSpec.getName(), (Object)pipelineOptionSpec.getGetterMethod());
            }
            for (Map.Entry entry : ifacePropGetterTable.rowMap().entrySet()) {
                Class currentIface = (Class)entry.getKey();
                Map propertyNamesToGetters = (Map)entry.getValue();
                @KeyFor(value={"propertyNamesToGetters"}) ArrayList lists = Lists.newArrayList(propertyNamesToGetters.keySet());
                lists.sort(String.CASE_INSENSITIVE_ORDER);
                for (String propertyName : lists) {
                    Method method = (Method)propertyNamesToGetters.get(propertyName);
                    if (!seenMethods.add(method)) continue;
                    Class<?> returnType = method.getReturnType();
                    JobApi.PipelineOptionType.Enum optionType = JobApi.PipelineOptionType.Enum.STRING;
                    if (JSON_INTEGER_TYPES.contains(returnType)) {
                        optionType = JobApi.PipelineOptionType.Enum.INTEGER;
                    } else if (JSON_NUMBER_TYPES.contains(returnType)) {
                        optionType = JobApi.PipelineOptionType.Enum.NUMBER;
                    } else if (returnType == Boolean.TYPE || returnType == Boolean.class) {
                        optionType = JobApi.PipelineOptionType.Enum.BOOLEAN;
                    } else if (List.class.isAssignableFrom(returnType)) {
                        optionType = JobApi.PipelineOptionType.Enum.ARRAY;
                    }
                    String optionName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, propertyName);
                    Description description = method.getAnnotation(Description.class);
                    JobApi.PipelineOptionDescriptor.Builder builder = JobApi.PipelineOptionDescriptor.newBuilder().setName(optionName).setType(optionType).setGroup(currentIface.getName());
                    Optional<String> defaultValue = PipelineOptionsFactory.getDefaultValueFromAnnotation(method);
                    if (defaultValue.isPresent()) {
                        builder.setDefaultValue((String)defaultValue.get());
                    }
                    if (description != null) {
                        builder.setDescription(description.value());
                    }
                    result.add(builder.build());
                }
            }
        }
        return result;
    }

    private static void prettyPrintRequiredGroups(@UnknownKeyFor @NonNull @Initialized PrintStream out, @UnknownKeyFor @NonNull @Initialized Validation.Required annotation, @UnknownKeyFor @NonNull @Initialized SortedSetMultimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> requiredGroupNameToProperties) {
        if (annotation == null || annotation.groups() == null) {
            return;
        }
        for (String group : annotation.groups()) {
            SortedSet groupMembers = requiredGroupNameToProperties.get((Object)group);
            String requirement = groupMembers.size() == 1 ? (String)Iterables.getOnlyElement((Iterable)groupMembers) + " is required." : "At least one of " + groupMembers + " is required";
            PipelineOptionsFactory.terminalPrettyPrint(out, requirement.split("\\s+"));
        }
    }

    private static void prettyPrintDescription(@UnknownKeyFor @NonNull @Initialized PrintStream out, @UnknownKeyFor @NonNull @Initialized Description description) {
        String[] words = description.value().split("\\s+");
        PipelineOptionsFactory.terminalPrettyPrint(out, words);
    }

    private static void terminalPrettyPrint(@UnknownKeyFor @NonNull @Initialized PrintStream out, @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] words) {
        String spacing = "   ";
        if (words.length == 0) {
            return;
        }
        out.print("   ");
        int lineLength = "   ".length();
        for (int i = 0; i < words.length; ++i) {
            out.print(" ");
            out.print(words[i]);
            if (i + 1 == words.length || words[i + 1].length() + (lineLength += 1 + words[i].length()) + 1 <= 80) continue;
            out.println();
            out.print("   ");
            lineLength = "   ".length();
        }
        out.println();
    }

    private static @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> getDefaultValueFromAnnotation(@UnknownKeyFor @NonNull @Initialized Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof Default.Class) {
                return Optional.of((Object)((Default.Class)annotation).value().getSimpleName());
            }
            if (annotation instanceof Default.String) {
                return Optional.of((Object)((Default.String)annotation).value());
            }
            if (annotation instanceof Default.Boolean) {
                return Optional.of((Object)Boolean.toString(((Default.Boolean)annotation).value()));
            }
            if (annotation instanceof Default.Character) {
                return Optional.of((Object)Character.toString(((Default.Character)annotation).value()));
            }
            if (annotation instanceof Default.Byte) {
                return Optional.of((Object)Byte.toString(((Default.Byte)annotation).value()));
            }
            if (annotation instanceof Default.Short) {
                return Optional.of((Object)Short.toString(((Default.Short)annotation).value()));
            }
            if (annotation instanceof Default.Integer) {
                return Optional.of((Object)Integer.toString(((Default.Integer)annotation).value()));
            }
            if (annotation instanceof Default.Long) {
                return Optional.of((Object)Long.toString(((Default.Long)annotation).value()));
            }
            if (annotation instanceof Default.Float) {
                return Optional.of((Object)Float.toString(((Default.Float)annotation).value()));
            }
            if (annotation instanceof Default.Double) {
                return Optional.of((Object)Double.toString(((Default.Double)annotation).value()));
            }
            if (annotation instanceof Default.Enum) {
                return Optional.of((Object)((Default.Enum)annotation).value());
            }
            if (!(annotation instanceof Default.InstanceFactory)) continue;
            return Optional.of((Object)((Default.InstanceFactory)annotation).value().getSimpleName());
        }
        return Optional.absent();
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineRunner<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> getRegisteredRunners() {
        return CACHE.get().supportedPipelineRunners;
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> getPropertyDescriptors(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Method> methods) throws @UnknownKeyFor @NonNull @Initialized IntrospectionException {
        TreeMap<String, Method> propertyNamesToGetters = new TreeMap<String, Method>();
        for (Map.Entry entry : PipelineOptionsReflector.getPropertyNamesToGetters(methods).entries()) {
            propertyNamesToGetters.put((String)entry.getKey(), (Method)entry.getValue());
        }
        ArrayList descriptors = Lists.newArrayList();
        ArrayList<TypeMismatch> mismatches = new ArrayList<TypeMismatch>();
        HashSet usedDescriptors = Sets.newHashSet();
        for (Method method : methods) {
            Type setterPropertyType;
            Type getterPropertyType;
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) continue;
            String propertyName = Introspector.decapitalize(methodName.substring(3));
            Method getterMethod = (Method)propertyNamesToGetters.remove(propertyName);
            if (getterMethod != null && !(getterPropertyType = getterMethod.getGenericReturnType()).equals(setterPropertyType = method.getGenericParameterTypes()[0])) {
                TypeMismatch mismatch = new TypeMismatch();
                mismatch.propertyName = propertyName;
                mismatch.getterPropertyType = getterPropertyType;
                mismatch.setterPropertyType = setterPropertyType;
                mismatches.add(mismatch);
                continue;
            }
            if (usedDescriptors.contains(propertyName)) continue;
            descriptors.add(new PropertyDescriptor(propertyName, getterMethod, method));
            usedDescriptors.add(propertyName);
        }
        PipelineOptionsFactory.throwForTypeMismatches(mismatches);
        for (Map.Entry entry : propertyNamesToGetters.entrySet()) {
            descriptors.add(new PropertyDescriptor((String)entry.getKey(), (Method)entry.getValue(), null));
        }
        return descriptors;
    }

    private static void throwForTypeMismatches(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TypeMismatch> mismatches) {
        if (mismatches.size() == 1) {
            TypeMismatch mismatch = mismatches.get(0);
            throw new IllegalArgumentException(String.format("Type mismatch between getter and setter methods for property [%s]. Getter is of type [%s] whereas setter is of type [%s].", mismatch.propertyName, mismatch.getterPropertyType, mismatch.setterPropertyType));
        }
        if (mismatches.size() > 1) {
            StringBuilder builder = new StringBuilder("Type mismatches between getters and setters detected:");
            for (TypeMismatch mismatch : mismatches) {
                builder.append(String.format("%n  - Property [%s]: Getter is of type [%s] whereas setter is of type [%s].", mismatch.propertyName, mismatch.getterPropertyType.toString(), mismatch.setterPropertyType.toString()));
            }
            throw new IllegalArgumentException(builder.toString());
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized SortedSetMultimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getRequiredGroupNamesToProperties(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Method> propertyNamesToGetters) {
        TreeMultimap result = TreeMultimap.create();
        for (Map.Entry<String, Method> propertyEntry : propertyNamesToGetters.entrySet()) {
            Validation.Required requiredAnnotation = propertyEntry.getValue().getAnnotation(Validation.Required.class);
            if (requiredAnnotation == null) continue;
            for (String groupName : requiredAnnotation.groups()) {
                result.put((Object)groupName, (Object)propertyEntry.getKey());
            }
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> validateClass(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> iface, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> validatedPipelineOptionsInterfaces, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> klass) throws @UnknownKeyFor @NonNull @Initialized IntrospectionException {
        Preconditions.checkArgument((boolean)Modifier.isPublic(iface.getModifiers()), (String)"Please mark non-public interface %s as public. The JVM requires that all non-public interfaces to be in the same package which will prevent the PipelineOptions proxy class to implement all of the interfaces.", (Object)iface.getName());
        PipelineOptionsFactory.validateReturnType(iface);
        SortedSet allInterfaceMethods = (SortedSet)Stream.concat(StreamSupport.stream(ReflectHelpers.getClosureOfMethodsOnInterfaces(validatedPipelineOptionsInterfaces).spliterator(), false), StreamSupport.stream(ReflectHelpers.getClosureOfMethodsOnInterface(iface).spliterator(), false)).filter(input -> !input.isSynthetic()).filter(input1 -> !Modifier.isStatic(input1.getModifiers())).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)MethodComparator.INSTANCE));
        List<PropertyDescriptor> descriptors = PipelineOptionsFactory.getPropertyDescriptors(allInterfaceMethods);
        PipelineOptionsFactory.validateMethodAnnotations(allInterfaceMethods, descriptors);
        PipelineOptionsFactory.validateGettersSetters(iface, descriptors);
        PipelineOptionsFactory.validateMethodsAreEitherBeanMethodOrKnownMethod(iface, klass, descriptors);
        return descriptors;
    }

    private static void validateReturnType(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> iface) {
        Iterable interfaceMethods = (Iterable)StreamSupport.stream(ReflectHelpers.getClosureOfMethodsOnInterface(iface).spliterator(), false).filter(input -> !input.isSynthetic()).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)MethodComparator.INSTANCE));
        TreeMultimap methodNameToMethodMap = TreeMultimap.create((Comparator)MethodNameComparator.INSTANCE, (Comparator)MethodComparator.INSTANCE);
        for (Method method : interfaceMethods) {
            methodNameToMethodMap.put((Object)method, (Object)method);
        }
        ArrayList multipleDefinitions = Lists.newArrayList();
        for (Map.Entry entry : methodNameToMethodMap.asMap().entrySet()) {
            Set returnTypes = ((Collection)entry.getValue()).stream().map(ReturnTypeFetchingFunction.INSTANCE).collect(Collectors.toSet());
            SortedSet collidingMethods = (SortedSet)StreamSupport.stream(((Collection)entry.getValue()).spliterator(), false).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)MethodComparator.INSTANCE));
            if (returnTypes.size() <= 1) continue;
            MultipleDefinitions defs = new MultipleDefinitions();
            defs.method = (Method)entry.getKey();
            defs.collidingMethods = collidingMethods;
            multipleDefinitions.add(defs);
        }
        PipelineOptionsFactory.throwForMultipleDefinitions(iface, multipleDefinitions);
    }

    private static void validateMethodAnnotations(@UnknownKeyFor @NonNull @Initialized SortedSet<@UnknownKeyFor @NonNull @Initialized Method> allInterfaceMethods, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> descriptors) {
        TreeMultimap methodNameToAllMethodMap = TreeMultimap.create((Comparator)MethodNameComparator.INSTANCE, (Comparator)MethodComparator.INSTANCE);
        for (Method method : allInterfaceMethods) {
            methodNameToAllMethodMap.put((Object)method, (Object)method);
        }
        PipelineOptionsFactory.validateGettersHaveConsistentAnnotation((SortedSetMultimap<Method, Method>)methodNameToAllMethodMap, descriptors, AnnotationPredicates.JSON_IGNORE);
        PipelineOptionsFactory.validateGettersHaveConsistentAnnotation((SortedSetMultimap<Method, Method>)methodNameToAllMethodMap, descriptors, AnnotationPredicates.DEFAULT_VALUE);
        PipelineOptionsFactory.validateGettersHaveConsistentAnnotation((SortedSetMultimap<Method, Method>)methodNameToAllMethodMap, descriptors, AnnotationPredicates.JSON_DESERIALIZE);
        PipelineOptionsFactory.validateGettersHaveConsistentAnnotation((SortedSetMultimap<Method, Method>)methodNameToAllMethodMap, descriptors, AnnotationPredicates.JSON_SERIALIZE);
        PipelineOptionsFactory.validateMethodsHaveBothJsonSerializeAndDeserialize(descriptors);
        PipelineOptionsFactory.validateSettersDoNotHaveAnnotation((SortedSetMultimap<Method, Method>)methodNameToAllMethodMap, descriptors, AnnotationPredicates.JSON_IGNORE);
        PipelineOptionsFactory.validateSettersDoNotHaveAnnotation((SortedSetMultimap<Method, Method>)methodNameToAllMethodMap, descriptors, AnnotationPredicates.DEFAULT_VALUE);
        PipelineOptionsFactory.validateSettersDoNotHaveAnnotation((SortedSetMultimap<Method, Method>)methodNameToAllMethodMap, descriptors, AnnotationPredicates.JSON_DESERIALIZE);
        PipelineOptionsFactory.validateSettersDoNotHaveAnnotation((SortedSetMultimap<Method, Method>)methodNameToAllMethodMap, descriptors, AnnotationPredicates.JSON_SERIALIZE);
    }

    private static void validateGettersHaveConsistentAnnotation(@UnknownKeyFor @NonNull @Initialized SortedSetMultimap<@UnknownKeyFor @NonNull @Initialized Method, @UnknownKeyFor @NonNull @Initialized Method> methodNameToAllMethodMap, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> descriptors, @UnknownKeyFor @NonNull @Initialized AnnotationPredicates annotationPredicates) {
        ArrayList<InconsistentlyAnnotatedGetters> inconsistentlyAnnotatedGetters = new ArrayList<InconsistentlyAnnotatedGetters>();
        for (PropertyDescriptor descriptor : descriptors) {
            if (descriptor.getReadMethod() == null || IGNORED_METHODS.contains(descriptor.getReadMethod())) continue;
            SortedSet getters = methodNameToAllMethodMap.get((Object)descriptor.getReadMethod());
            SortedSet gettersWithTheAnnotation = Sets.filter((SortedSet)getters, annotationPredicates.forMethod);
            Set distinctAnnotations = gettersWithTheAnnotation.stream().flatMap(method -> Arrays.stream(method.getAnnotations())).filter(annotationPredicates.forAnnotation).collect(Collectors.toSet());
            if (distinctAnnotations.size() > 1) {
                throw new IllegalArgumentException(String.format("Property [%s] is marked with contradictory annotations. Found [%s].", descriptor.getName(), gettersWithTheAnnotation.stream().flatMap(method -> Arrays.stream(method.getAnnotations()).filter((Predicate<Annotation>)annotationPredicates.forAnnotation).map(annotation -> String.format("[%s on %s]", ReflectHelpers.formatAnnotation(annotation), ReflectHelpers.formatMethodWithClass(method)))).collect(Collectors.joining(", "))));
            }
            Iterable getterClassNames = getters.stream().map(MethodToDeclaringClassFunction.INSTANCE).map(Class::getName).collect(Collectors.toList());
            Iterable gettersWithTheAnnotationClassNames = gettersWithTheAnnotation.stream().map(MethodToDeclaringClassFunction.INSTANCE).map(Class::getName).collect(Collectors.toList());
            if (gettersWithTheAnnotation.isEmpty() || getters.size() == gettersWithTheAnnotation.size()) continue;
            InconsistentlyAnnotatedGetters err = new InconsistentlyAnnotatedGetters();
            err.descriptor = descriptor;
            err.getterClassNames = getterClassNames;
            err.gettersWithTheAnnotationClassNames = gettersWithTheAnnotationClassNames;
            inconsistentlyAnnotatedGetters.add(err);
        }
        PipelineOptionsFactory.throwForGettersWithInconsistentAnnotation(inconsistentlyAnnotatedGetters, annotationPredicates.annotationClass);
    }

    private static void validateSettersDoNotHaveAnnotation(@UnknownKeyFor @NonNull @Initialized SortedSetMultimap<@UnknownKeyFor @NonNull @Initialized Method, @UnknownKeyFor @NonNull @Initialized Method> methodNameToAllMethodMap, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> descriptors, @UnknownKeyFor @NonNull @Initialized AnnotationPredicates annotationPredicates) {
        ArrayList<AnnotatedSetter> annotatedSetters = new ArrayList<AnnotatedSetter>();
        for (PropertyDescriptor descriptor : descriptors) {
            if (descriptor.getWriteMethod() == null || IGNORED_METHODS.contains(descriptor.getWriteMethod())) continue;
            SortedSet settersWithTheAnnotation = Sets.filter((SortedSet)methodNameToAllMethodMap.get((Object)descriptor.getWriteMethod()), annotationPredicates.forMethod);
            Iterable settersWithTheAnnotationClassNames = settersWithTheAnnotation.stream().map(MethodToDeclaringClassFunction.INSTANCE).map(Class::getName).collect(Collectors.toList());
            if (settersWithTheAnnotation.isEmpty()) continue;
            AnnotatedSetter annotated = new AnnotatedSetter();
            annotated.descriptor = descriptor;
            annotated.settersWithTheAnnotationClassNames = settersWithTheAnnotationClassNames;
            annotatedSetters.add(annotated);
        }
        PipelineOptionsFactory.throwForSettersWithTheAnnotation(annotatedSetters, annotationPredicates.annotationClass);
    }

    private static void validateGettersSetters(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> iface, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> descriptors) {
        ArrayList<MissingBeanMethod> missingBeanMethods = new ArrayList<MissingBeanMethod>();
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            MissingBeanMethod method;
            if (!IGNORED_METHODS.contains(propertyDescriptor.getWriteMethod()) && propertyDescriptor.getReadMethod() == null) {
                method = new MissingBeanMethod();
                method.property = propertyDescriptor;
                method.methodType = "getter";
                missingBeanMethods.add(method);
                continue;
            }
            if (IGNORED_METHODS.contains(propertyDescriptor.getReadMethod()) || propertyDescriptor.getWriteMethod() != null) continue;
            method = new MissingBeanMethod();
            method.property = propertyDescriptor;
            method.methodType = "setter";
            missingBeanMethods.add(method);
        }
        PipelineOptionsFactory.throwForMissingBeanMethod(iface, missingBeanMethods);
    }

    private static void validateMethodsAreEitherBeanMethodOrKnownMethod(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> iface, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> klass, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> descriptors) {
        HashSet knownMethods = Sets.newHashSet(IGNORED_METHODS);
        for (Method method : klass.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) && !method.isSynthetic()) continue;
            knownMethods.add(method);
        }
        try {
            knownMethods.add(iface.getMethod("as", Class.class));
            knownMethods.add(iface.getMethod("outputRuntimeOptions", new Class[0]));
            knownMethods.add(iface.getMethod("populateDisplayData", DisplayData.Builder.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        for (PropertyDescriptor descriptor : descriptors) {
            knownMethods.add(descriptor.getReadMethod());
            knownMethods.add(descriptor.getWriteMethod());
        }
        HashSet knownMethodsNames = Sets.newHashSet();
        for (Method method : knownMethods) {
            knownMethodsNames.add(method.getName());
        }
        TreeSet<Method> unknownMethods = new TreeSet<Method>(MethodComparator.INSTANCE);
        unknownMethods.addAll(Sets.filter((Set)Sets.difference((Set)Sets.newHashSet((Object[])iface.getMethods()), (Set)knownMethods), (org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate)Predicates.and((org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate[])new org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate[]{input1 -> !input1.isSynthetic(), input -> !knownMethodsNames.contains(input.getName()), input11 -> !Modifier.isStatic(input11.getModifiers())})));
        Preconditions.checkArgument((boolean)unknownMethods.isEmpty(), (String)"Methods [%s] on [%s] do not conform to being bean properties.", (Object)unknownMethods.stream().map(ReflectHelpers::formatMethod).collect(Collectors.joining(",")), (Object)iface.getName());
    }

    private static void validateMethodsHaveBothJsonSerializeAndDeserialize(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> descriptors) {
        ArrayList inconsistentMethods = Lists.newArrayList();
        for (PropertyDescriptor descriptor : descriptors) {
            boolean hasJsonDeserialize;
            boolean hasJsonSerialize;
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null || IGNORED_METHODS.contains(descriptor.getReadMethod()) || !((hasJsonSerialize = AnnotationPredicates.JSON_SERIALIZE.forMethod.apply((Object)readMethod)) ^ (hasJsonDeserialize = AnnotationPredicates.JSON_DESERIALIZE.forMethod.apply((Object)readMethod)))) continue;
            InconsistentJsonSerializeAndDeserializeAnnotation inconsistentAnnotation = new InconsistentJsonSerializeAndDeserializeAnnotation();
            inconsistentAnnotation.property = descriptor;
            inconsistentAnnotation.hasJsonDeserializeAttribute = hasJsonDeserialize;
            inconsistentMethods.add(inconsistentAnnotation);
        }
        PipelineOptionsFactory.throwForInconsistentJsonSerializeAndDeserializeAnnotation(inconsistentMethods);
    }

    private static void checkInheritedFrom(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> checkClass, @UnknownKeyFor @NonNull @Initialized Class fromClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> nonPipelineOptions) {
        if (checkClass.equals(fromClass)) {
            return;
        }
        if (checkClass.getInterfaces().length == 0) {
            nonPipelineOptions.add(checkClass);
            return;
        }
        for (Class<?> klass : checkClass.getInterfaces()) {
            PipelineOptionsFactory.checkInheritedFrom(klass, fromClass, nonPipelineOptions);
        }
    }

    private static void throwNonPipelineOptions(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> klass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> nonPipelineOptionsClasses) {
        StringBuilder errorBuilder = new StringBuilder(String.format("All inherited interfaces of [%s] should inherit from the PipelineOptions interface. The following inherited interfaces do not:", klass.getName()));
        for (Class<?> invalidKlass : nonPipelineOptionsClasses) {
            errorBuilder.append(String.format("%n - %s", invalidKlass.getName()));
        }
        throw new IllegalArgumentException(errorBuilder.toString());
    }

    private static void validateInheritedInterfacesExtendPipelineOptions(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> klass) {
        LinkedHashSet nonPipelineOptionsClasses = new LinkedHashSet();
        PipelineOptionsFactory.checkInheritedFrom(klass, PipelineOptions.class, nonPipelineOptionsClasses);
        if (!nonPipelineOptionsClasses.isEmpty()) {
            PipelineOptionsFactory.throwNonPipelineOptions(klass, nonPipelineOptionsClasses);
        }
    }

    private static void throwForMultipleDefinitions(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> iface, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MultipleDefinitions> definitions) {
        if (definitions.size() == 1) {
            MultipleDefinitions errDef = definitions.get(0);
            throw new IllegalArgumentException(String.format("Method [%s] has multiple definitions %s with different return types for [%s].", errDef.method.getName(), errDef.collidingMethods, iface.getName()));
        }
        if (definitions.size() > 1) {
            StringBuilder errorBuilder = new StringBuilder(String.format("Interface [%s] has Methods with multiple definitions with different return types:", iface.getName()));
            for (MultipleDefinitions errDef : definitions) {
                errorBuilder.append(String.format("%n  - Method [%s] has multiple definitions %s", errDef.method.getName(), errDef.collidingMethods));
            }
            throw new IllegalArgumentException(errorBuilder.toString());
        }
    }

    private static void throwForGettersWithInconsistentAnnotation(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized InconsistentlyAnnotatedGetters> getters, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Annotation> annotationClass) {
        if (getters.size() == 1) {
            InconsistentlyAnnotatedGetters getter = getters.get(0);
            throw new IllegalArgumentException(String.format("Expected getter for property [%s] to be marked with @%s on all %s, found only on %s", getter.descriptor.getName(), annotationClass.getSimpleName(), getter.getterClassNames, getter.gettersWithTheAnnotationClassNames));
        }
        if (getters.size() > 1) {
            StringBuilder errorBuilder = new StringBuilder(String.format("Property getters are inconsistently marked with @%s:", annotationClass.getSimpleName()));
            for (InconsistentlyAnnotatedGetters getter : getters) {
                errorBuilder.append(String.format("%n  - Expected for property [%s] to be marked on all %s, found only on %s", getter.descriptor.getName(), getter.getterClassNames, getter.gettersWithTheAnnotationClassNames));
            }
            throw new IllegalArgumentException(errorBuilder.toString());
        }
    }

    private static void throwForSettersWithTheAnnotation(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AnnotatedSetter> setters, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Annotation> annotationClass) {
        if (setters.size() == 1) {
            AnnotatedSetter setter = setters.get(0);
            throw new IllegalArgumentException(String.format("Expected setter for property [%s] to not be marked with @%s on %s", setter.descriptor.getName(), annotationClass.getSimpleName(), setter.settersWithTheAnnotationClassNames));
        }
        if (setters.size() > 1) {
            StringBuilder builder = new StringBuilder(String.format("Found setters marked with @%s:", annotationClass.getSimpleName()));
            for (AnnotatedSetter setter : setters) {
                builder.append(String.format("%n  - Setter for property [%s] should not be marked with @%s on %s", setter.descriptor.getName(), annotationClass.getSimpleName(), setter.settersWithTheAnnotationClassNames));
            }
            throw new IllegalArgumentException(builder.toString());
        }
    }

    private static void throwForMissingBeanMethod(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> iface, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MissingBeanMethod> missingBeanMethods) {
        if (missingBeanMethods.size() == 1) {
            MissingBeanMethod missingBeanMethod = missingBeanMethods.get(0);
            throw new IllegalArgumentException(String.format("Expected %s for property [%s] of type [%s] on [%s].", missingBeanMethod.methodType, missingBeanMethod.property.getName(), missingBeanMethod.property.getPropertyType().getName(), iface.getName()));
        }
        if (missingBeanMethods.size() > 1) {
            StringBuilder builder = new StringBuilder(String.format("Found missing property methods on [%s]:", iface.getName()));
            for (MissingBeanMethod method : missingBeanMethods) {
                builder.append(String.format("%n  - Expected %s for property [%s] of type [%s]", method.methodType, method.property.getName(), method.property.getPropertyType().getName()));
            }
            throw new IllegalArgumentException(builder.toString());
        }
    }

    private static void throwForInconsistentJsonSerializeAndDeserializeAnnotation(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized InconsistentJsonSerializeAndDeserializeAnnotation> inconsistentAnnotations) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
        if (inconsistentAnnotations.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder("Found incorrectly annotated property methods, if a method is annotated with either @JsonSerialize or @JsonDeserialize then it must be annotated with both.");
        for (InconsistentJsonSerializeAndDeserializeAnnotation annotation : inconsistentAnnotations) {
            String presentAnnotation = annotation.hasJsonDeserializeAttribute ? "JsonDeserialize" : "JsonSerialize";
            builder.append(String.format("%n  - Property [%s] had only @%s", annotation.property.getName(), presentAnnotation));
        }
        throw new IllegalArgumentException(builder.toString());
    }

    private static @UnknownKeyFor @NonNull @Initialized ListMultimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> parseCommandLine(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args, @UnknownKeyFor @NonNull @Initialized boolean strictParsing) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (String arg : args) {
            if (Strings.isNullOrEmpty((String)arg)) continue;
            try {
                Preconditions.checkArgument((boolean)arg.startsWith("--"), (String)"Argument '%s' does not begin with '--'", (Object)arg);
                int index = arg.indexOf(61);
                Preconditions.checkArgument((index != 2 ? 1 : 0) != 0, (String)"Argument '%s' starts with '--=', empty argument name not allowed", (Object)arg);
                if (index > 0) {
                    builder.put((Object)arg.substring(2, index), (Object)arg.substring(index + 1, arg.length()));
                    continue;
                }
                builder.put((Object)arg.substring(2), (Object)"true");
            }
            catch (IllegalArgumentException e) {
                if (strictParsing) {
                    throw e;
                }
                LOG.warn("Strict parsing is disabled, ignoring option '{}' because {}", (Object)arg, (Object)e.getMessage());
            }
        }
        return builder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized BeanProperty createBeanProperty(@UnknownKeyFor @NonNull @Initialized Method method) {
        AnnotationCollector ac = AnnotationCollector.emptyCollector();
        for (Annotation ann : method.getAnnotations()) {
            ac = ac.addOrOverride(ann);
        }
        AnnotatedMethod annotatedMethod = new AnnotatedMethod((TypeResolutionContext)new TypeResolutionContext.Basic(MAPPER.getTypeFactory(), TypeBindings.emptyBindings()), method, ac.asAnnotationMap(), null);
        SimpleBeanPropertyDefinition propDef = SimpleBeanPropertyDefinition.construct((MapperConfig)MAPPER.getDeserializationConfig(), (AnnotatedMember)annotatedMethod);
        JavaType type = MAPPER.constructType(method.getGenericReturnType());
        try {
            return new MethodProperty((BeanPropertyDefinition)propDef, type, MAPPER.getDeserializationConfig().findTypeDeserializer(type), (Annotations)annotatedMethod.getAllAnnotations(), annotatedMethod);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized JsonDeserializer<@UnknownKeyFor @NonNull @Initialized Object> computeDeserializerForMethod(@UnknownKeyFor @NonNull @Initialized Method method) {
        try {
            TypeDeserializer typeDeserializer;
            BeanProperty prop = PipelineOptionsFactory.createBeanProperty(method);
            AnnotatedMember annotatedMethod = prop.getMember();
            DefaultDeserializationContext context = DESERIALIZATION_CONTEXT.get();
            Object maybeDeserializerClass = context.getAnnotationIntrospector().findDeserializer((Annotated)annotatedMethod);
            JsonDeserializer jsonDeserializer = context.deserializerInstance((Annotated)annotatedMethod, maybeDeserializerClass);
            if (jsonDeserializer == null) {
                jsonDeserializer = context.findContextualValueDeserializer(prop.getType(), prop);
            }
            if ((typeDeserializer = context.getFactory().findTypeDeserializer(context.getConfig(), prop.getType())) != null) {
                jsonDeserializer = new TypeWrappedDeserializer(typeDeserializer, jsonDeserializer);
            }
            return jsonDeserializer;
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized JsonSerializer<@UnknownKeyFor @NonNull @Initialized Object>> computeCustomSerializerForMethod(@UnknownKeyFor @NonNull @Initialized Method method) {
        try {
            BeanProperty prop = PipelineOptionsFactory.createBeanProperty(method);
            AnnotatedMember annotatedMethod = prop.getMember();
            Object maybeSerializerClass = SERIALIZER_PROVIDER.getAnnotationIntrospector().findSerializer((Annotated)annotatedMethod);
            return Optional.fromNullable((Object)SERIALIZER_PROVIDER.serializerInstance((Annotated)annotatedMethod, maybeSerializerClass));
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized JsonDeserializer<@UnknownKeyFor @NonNull @Initialized Object> getDeserializerForMethod(@UnknownKeyFor @NonNull @Initialized Method method) {
        return CACHE.get().deserializerCache.computeIfAbsent(method, PipelineOptionsFactory::computeDeserializerForMethod);
    }

    static @Nullable @UnknownKeyFor @Initialized JsonSerializer<@UnknownKeyFor @NonNull @Initialized Object> getCustomSerializerForMethod(@UnknownKeyFor @NonNull @Initialized Method method) {
        return (JsonSerializer)CACHE.get().serializerCache.computeIfAbsent(method, PipelineOptionsFactory::computeCustomSerializerForMethod).orNull();
    }

    static @UnknownKeyFor @NonNull @Initialized Object deserializeNode(@UnknownKeyFor @NonNull @Initialized JsonNode node, @UnknownKeyFor @NonNull @Initialized Method method) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (node.isNull()) {
            return null;
        }
        TreeTraversingParser parser = new TreeTraversingParser(node, (ObjectCodec)MAPPER);
        parser.nextToken();
        JsonDeserializer<Object> jsonDeserializer = PipelineOptionsFactory.getDeserializerForMethod(method);
        return jsonDeserializer.deserialize((JsonParser)parser, (DeserializationContext)DESERIALIZATION_CONTEXT.get());
    }

    private static @UnknownKeyFor @NonNull @Initialized Object tryParseObject(@UnknownKeyFor @NonNull @Initialized String value, @UnknownKeyFor @NonNull @Initialized Method method) throws @UnknownKeyFor @NonNull @Initialized IOException {
        JsonNode tree;
        try {
            tree = MAPPER.readTree(value);
        }
        catch (JsonParseException e) {
            if (!value.startsWith("\"") || !value.endsWith("\"")) {
                try {
                    tree = MAPPER.readTree("\"" + value + "\"");
                }
                catch (JsonParseException inner) {
                    throw e;
                }
            }
            throw e;
        }
        return PipelineOptionsFactory.deserializeNode(tree, method);
    }

    private static <T extends PipelineOptions> @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parseObjects(@UnknownKeyFor @NonNull @Initialized Class<T> klass, @UnknownKeyFor @NonNull @Initialized ListMultimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> options, @UnknownKeyFor @NonNull @Initialized boolean strictParsing) {
        HashMap propertyNamesToGetters = Maps.newHashMap();
        Cache cache = CACHE.get();
        cache.validateWellFormed(klass);
        List<PropertyDescriptor> propertyDescriptors = cache.getPropertyDescriptors(Stream.concat(PipelineOptionsFactory.getRegisteredOptions().stream(), Stream.of(klass)).collect(Collectors.toSet()));
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            propertyNamesToGetters.put(descriptor.getName(), descriptor.getReadMethod());
        }
        HashMap convertedOptions = Maps.newHashMap();
        for (Map.Entry entry : options.asMap().entrySet()) {
            try {
                String value;
                if (!propertyNamesToGetters.containsKey(entry.getKey())) {
                    TreeSet closestMatches = new TreeSet(Sets.filter(propertyNamesToGetters.keySet(), input -> StringUtils.getLevenshteinDistance((String)entry.getKey(), input) <= 2));
                    switch (closestMatches.size()) {
                        case 0: {
                            throw new IllegalArgumentException(String.format("Class %s missing a property named '%s'.", klass, entry.getKey()));
                        }
                        case 1: {
                            throw new IllegalArgumentException(String.format("Class %s missing a property named '%s'. Did you mean '%s'?", klass, entry.getKey(), Iterables.getOnlyElement(closestMatches)));
                        }
                    }
                    throw new IllegalArgumentException(String.format("Class %s missing a property named '%s'. Did you mean one of %s?", klass, entry.getKey(), closestMatches));
                }
                Method method = (Method)propertyNamesToGetters.get(entry.getKey());
                Class<?> returnType = method.getReturnType();
                JavaType type = MAPPER.getTypeFactory().constructType(method.getGenericReturnType());
                if ("runner".equals(entry.getKey())) {
                    String runner = (String)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()));
                    Map pipelineRunners = cache.supportedPipelineRunners;
                    if (pipelineRunners.containsKey(runner.toLowerCase())) {
                        convertedOptions.put("runner", pipelineRunners.get(runner.toLowerCase(Locale.ROOT)));
                        continue;
                    }
                    try {
                        Class<?> runnerClass = Class.forName(runner, true, ReflectHelpers.findClassLoader());
                        if (!PipelineRunner.class.isAssignableFrom(runnerClass)) {
                            throw new IllegalArgumentException(String.format("Class '%s' does not implement PipelineRunner. Supported pipeline runners %s", runner, cache.getSupportedRunners()));
                        }
                        convertedOptions.put("runner", runnerClass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        String msg = String.format("Unknown 'runner' specified '%s', supported pipeline runners %s", runner, cache.getSupportedRunners());
                        throw new IllegalArgumentException(msg, e);
                    }
                }
                if (PipelineOptionsFactory.isCollectionOrArrayOfAllowedTypes(returnType, type)) {
                    List values = ((Collection)entry.getValue()).stream().flatMap(input -> Arrays.stream(input.split(","))).collect(Collectors.toList());
                    if (values.contains("")) {
                        PipelineOptionsFactory.checkEmptyStringAllowed(returnType, type, method.getGenericReturnType().toString());
                    }
                    convertedOptions.put((String)entry.getKey(), MAPPER.convertValue(values, type));
                    continue;
                }
                if (PipelineOptionsFactory.isSimpleType(returnType, type)) {
                    value = (String)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()));
                    if (value.isEmpty()) {
                        PipelineOptionsFactory.checkEmptyStringAllowed(returnType, type, method.getGenericReturnType().toString());
                    }
                    convertedOptions.put((String)entry.getKey(), MAPPER.convertValue((Object)value, type));
                    continue;
                }
                value = (String)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()));
                if (value.isEmpty()) {
                    PipelineOptionsFactory.checkEmptyStringAllowed(returnType, type, method.getGenericReturnType().toString());
                }
                try {
                    convertedOptions.put((String)entry.getKey(), PipelineOptionsFactory.tryParseObject(value, method));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to parse JSON value " + value, e);
                }
            }
            catch (IllegalArgumentException e) {
                if (strictParsing) {
                    throw e;
                }
                LOG.warn("Strict parsing is disabled, ignoring option '{}' with value '{}' because {}", new Object[]{entry.getKey(), entry.getValue(), e.getMessage()});
            }
        }
        return convertedOptions;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isSimpleType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized JavaType genericType) {
        Class unwrappedType = type.equals(ValueProvider.class) ? genericType.containedType(0).getRawClass() : type;
        return SIMPLE_TYPES.contains((Object)unwrappedType) || unwrappedType.isEnum();
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isCollectionOrArrayOfAllowedTypes(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized JavaType genericType) {
        JavaType innerType;
        JavaType containerType;
        JavaType javaType = containerType = type.equals(ValueProvider.class) ? genericType.containedType(0) : genericType;
        if (containerType.getRawClass().isArray() && (SIMPLE_TYPES.contains(containerType.getRawClass().getComponentType()) || containerType.getRawClass().getComponentType().isEnum())) {
            return true;
        }
        return Collection.class.isAssignableFrom(containerType.getRawClass()) && ((innerType = containerType.containedType(0)) == null || SIMPLE_TYPES.contains((Object)innerType.getRawClass()) || innerType.getRawClass().isEnum());
    }

    private static void checkEmptyStringAllowed(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized JavaType genericType, @UnknownKeyFor @NonNull @Initialized String genericTypeName) {
        JavaType unwrappedType = type.equals(ValueProvider.class) ? genericType.containedType(0) : genericType;
        Class containedType = unwrappedType.getRawClass();
        if (unwrappedType.getRawClass().isArray()) {
            containedType = unwrappedType.getRawClass().getComponentType();
        } else if (Collection.class.isAssignableFrom(unwrappedType.getRawClass())) {
            JavaType innerType = unwrappedType.containedType(0);
            Class clazz = containedType = innerType == null ? String.class : innerType.getRawClass();
        }
        if (!containedType.equals(String.class)) {
            String msg = String.format("Empty argument value is only allowed for String, String Array, Collections of Strings or any of these types in a parameterized ValueProvider, but received: %s", genericTypeName);
            throw new IllegalArgumentException(msg);
        }
    }

    static /* synthetic */ String access$100() {
        return PipelineOptionsFactory.findCallersClassName();
    }

    static {
        CACHE = new AtomicReference();
        try {
            IGNORED_METHODS = ImmutableSet.builder().add((Object)Object.class.getMethod("getClass", new Class[0])).add((Object)Object.class.getMethod("wait", new Class[0])).add((Object)Object.class.getMethod("wait", Long.TYPE)).add((Object)Object.class.getMethod("wait", Long.TYPE, Integer.TYPE)).add((Object)Object.class.getMethod("notify", new Class[0])).add((Object)Object.class.getMethod("notifyAll", new Class[0])).add((Object)Proxy.class.getMethod("getInvocationHandler", Object.class)).build();
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.error("Unable to find expected method", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        PipelineOptionsFactory.resetCache();
        JSON_INTEGER_TYPES = Sets.newHashSet((Object[])new Class[]{Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class});
        JSON_NUMBER_TYPES = Sets.newHashSet((Object[])new Class[]{Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class});
    }

    static final class Cache {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineRunner<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> supportedPipelineRunners;
        private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> registeredOptions = Sets.newConcurrentHashSet();
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>, @UnknownKeyFor @NonNull @Initialized Registration<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> interfaceCache = Maps.newConcurrentMap();
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>>, @UnknownKeyFor @NonNull @Initialized Registration<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> combinedCache = Maps.newConcurrentMap();
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Method, @UnknownKeyFor @NonNull @Initialized JsonDeserializer<@UnknownKeyFor @NonNull @Initialized Object>> deserializerCache = Maps.newConcurrentMap();
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Method, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized JsonSerializer<@UnknownKeyFor @NonNull @Initialized Object>>> serializerCache = Maps.newConcurrentMap();

        private Cache() {
            ClassLoader loader = ReflectHelpers.findClassLoader();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (PipelineRunnerRegistrar registrar : ReflectHelpers.loadServicesOrdered(PipelineRunnerRegistrar.class, loader)) {
                for (Class<PipelineRunner<?>> klass : registrar.getPipelineRunners()) {
                    String runnerName = klass.getSimpleName().toLowerCase();
                    builder.put((Object)runnerName, klass);
                    if (!runnerName.endsWith("runner")) continue;
                    builder.put((Object)runnerName.substring(0, runnerName.length() - "Runner".length()), klass);
                }
            }
            this.supportedPipelineRunners = builder.build();
            this.initializeRegistry(loader);
        }

        private void initializeRegistry(@UnknownKeyFor @NonNull @Initialized ClassLoader loader) {
            for (PipelineOptionsRegistrar registrar : ReflectHelpers.loadServicesOrdered(PipelineOptionsRegistrar.class, loader)) {
                for (Class<? extends PipelineOptions> klass : registrar.getPipelineOptions()) {
                    this.register(klass);
                }
            }
        }

        private synchronized void register(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> iface) {
            Preconditions.checkNotNull(iface);
            Preconditions.checkArgument((boolean)iface.isInterface(), (Object)"Only interface types are supported.");
            if (this.registeredOptions.contains(iface)) {
                return;
            }
            this.validateWellFormed(iface);
            this.registeredOptions.add(iface);
        }

        private <T extends PipelineOptions> @UnknownKeyFor @NonNull @Initialized Registration<T> validateWellFormed(@UnknownKeyFor @NonNull @Initialized Class<T> iface) {
            return this.validateWellFormed(iface, this.registeredOptions);
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSupportedRunners() {
            ImmutableSortedSet.Builder supportedRunners = ImmutableSortedSet.naturalOrder();
            for (Class<PipelineRunner<?>> runner : this.supportedPipelineRunners.values()) {
                supportedRunners.add((Object)runner.getSimpleName());
            }
            return supportedRunners.build();
        }

        @VisibleForTesting
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineRunner<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> getSupportedPipelineRunners() {
            return this.supportedPipelineRunners;
        }

        synchronized <T extends PipelineOptions> @UnknownKeyFor @NonNull @Initialized Registration<T> validateWellFormed(@UnknownKeyFor @NonNull @Initialized Class<T> iface, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> validatedPipelineOptionsInterfaces) {
            Preconditions.checkArgument((boolean)iface.isInterface(), (Object)"Only interface types are supported.");
            PipelineOptionsFactory.validateInheritedInterfacesExtendPipelineOptions(iface);
            Set<Class> combinedPipelineOptionsInterfaces = Stream.concat(validatedPipelineOptionsInterfaces.stream(), Stream.of(iface)).collect(Collectors.toSet());
            if (!this.combinedCache.containsKey(combinedPipelineOptionsInterfaces)) {
                Class[] interfaces = combinedPipelineOptionsInterfaces.toArray(EMPTY_CLASS_ARRAY);
                Class<?> allProxyClass = Proxy.getProxyClass(ReflectHelpers.findClassLoader(interfaces), interfaces);
                try {
                    List propertyDescriptors = PipelineOptionsFactory.validateClass(iface, validatedPipelineOptionsInterfaces, allProxyClass);
                    this.combinedCache.put(combinedPipelineOptionsInterfaces, new Registration(allProxyClass, propertyDescriptors));
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.interfaceCache.containsKey(iface)) {
                Class<?> proxyClass = Proxy.getProxyClass(ReflectHelpers.findClassLoader(iface), iface);
                try {
                    List propertyDescriptors = PipelineOptionsFactory.validateClass(iface, validatedPipelineOptionsInterfaces, proxyClass);
                    this.interfaceCache.put(iface, new Registration(proxyClass, propertyDescriptors));
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException(e);
                }
            }
            Registration<?> result = this.interfaceCache.get(iface);
            return result;
        }

        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> getPropertyDescriptors(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> interfaces) {
            return this.combinedCache.get(interfaces).getPropertyDescriptors();
        }
    }

    static class AnnotationPredicates {
        static final @UnknownKeyFor @NonNull @Initialized AnnotationPredicates JSON_IGNORE = new AnnotationPredicates(JsonIgnore.class, (org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<Annotation>)((org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate)input -> JsonIgnore.class.equals(input.annotationType())), (org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<Method>)((org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate)input -> input.isAnnotationPresent(JsonIgnore.class)));
        private static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> DEFAULT_ANNOTATION_CLASSES = Sets.newHashSet((Iterable)Arrays.stream(Default.class.getDeclaredClasses()).filter(Class::isAnnotation).collect(Collectors.toSet()));
        static final @UnknownKeyFor @NonNull @Initialized AnnotationPredicates DEFAULT_VALUE = new AnnotationPredicates(Default.class, (org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<Annotation>)((org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate)input -> DEFAULT_ANNOTATION_CLASSES.contains(input.annotationType())), (org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<Method>)((org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate)input -> {
            for (Annotation annotation : input.getAnnotations()) {
                if (!DEFAULT_ANNOTATION_CLASSES.contains(annotation.annotationType())) continue;
                return true;
            }
            return false;
        }));
        static final @UnknownKeyFor @NonNull @Initialized AnnotationPredicates JSON_DESERIALIZE = new AnnotationPredicates(JsonDeserialize.class, (org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<Annotation>)((org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate)input -> JsonDeserialize.class.equals(input.annotationType())), (org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<Method>)((org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate)input -> input.isAnnotationPresent(JsonDeserialize.class)));
        static final @UnknownKeyFor @NonNull @Initialized AnnotationPredicates JSON_SERIALIZE = new AnnotationPredicates(JsonSerialize.class, (org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<Annotation>)((org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate)input -> JsonSerialize.class.equals(input.annotationType())), (org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<Method>)((org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate)input -> input.isAnnotationPresent(JsonSerialize.class)));
        final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Annotation> annotationClass;
        final @UnknownKeyFor @NonNull @Initialized org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<@UnknownKeyFor @NonNull @Initialized Annotation> forAnnotation;
        final @UnknownKeyFor @NonNull @Initialized org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<@UnknownKeyFor @NonNull @Initialized Method> forMethod;

        AnnotationPredicates(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Annotation> annotationClass, @UnknownKeyFor @NonNull @Initialized org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<@UnknownKeyFor @NonNull @Initialized Annotation> forAnnotation, @UnknownKeyFor @NonNull @Initialized org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate<@UnknownKeyFor @NonNull @Initialized Method> forMethod) {
            this.annotationClass = annotationClass;
            this.forAnnotation = forAnnotation;
            this.forMethod = forMethod;
        }
    }

    private static class MethodToDeclaringClassFunction
    implements Function<Method, Class<?>> {
        static final @UnknownKeyFor @NonNull @Initialized MethodToDeclaringClassFunction INSTANCE = new MethodToDeclaringClassFunction();

        private MethodToDeclaringClassFunction() {
        }

        @Override
        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> apply(@Nonnull @UnknownKeyFor @NonNull @Initialized Method input) {
            return input.getDeclaringClass();
        }
    }

    private static class ReturnTypeFetchingFunction
    implements Function<Method, Class<?>> {
        static final @UnknownKeyFor @NonNull @Initialized ReturnTypeFetchingFunction INSTANCE = new ReturnTypeFetchingFunction();

        private ReturnTypeFetchingFunction() {
        }

        @Override
        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> apply(@Nonnull @UnknownKeyFor @NonNull @Initialized Method input) {
            return input.getReturnType();
        }
    }

    static class MethodNameComparator
    implements Comparator<Method> {
        static final @UnknownKeyFor @NonNull @Initialized MethodNameComparator INSTANCE = new MethodNameComparator();

        MethodNameComparator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized Method o1, @UnknownKeyFor @NonNull @Initialized Method o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class MethodComparator
    implements Comparator<Method> {
        static final @UnknownKeyFor @NonNull @Initialized MethodComparator INSTANCE = new MethodComparator();

        private MethodComparator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized Method o1, @UnknownKeyFor @NonNull @Initialized Method o2) {
            return o1.toGenericString().compareTo(o2.toGenericString());
        }
    }

    private static class ClassNameComparator
    implements Comparator<Class<?>> {
        static final @UnknownKeyFor @NonNull @Initialized ClassNameComparator INSTANCE = new ClassNameComparator();

        private ClassNameComparator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> o1, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class InconsistentJsonSerializeAndDeserializeAnnotation {
        @UnknownKeyFor @NonNull @Initialized PropertyDescriptor property;
        @UnknownKeyFor @NonNull @Initialized boolean hasJsonDeserializeAttribute;

        private InconsistentJsonSerializeAndDeserializeAnnotation() {
        }
    }

    private static class MissingBeanMethod {
        @UnknownKeyFor @NonNull @Initialized String methodType;
        @UnknownKeyFor @NonNull @Initialized PropertyDescriptor property;

        private MissingBeanMethod() {
        }
    }

    private static class AnnotatedSetter {
        @UnknownKeyFor @NonNull @Initialized PropertyDescriptor descriptor;
        @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> settersWithTheAnnotationClassNames;

        private AnnotatedSetter() {
        }
    }

    private static class InconsistentlyAnnotatedGetters {
        @UnknownKeyFor @NonNull @Initialized PropertyDescriptor descriptor;
        @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> getterClassNames;
        @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> gettersWithTheAnnotationClassNames;

        private InconsistentlyAnnotatedGetters() {
        }
    }

    private static class MultipleDefinitions {
        private @UnknownKeyFor @NonNull @Initialized Method method;
        private @UnknownKeyFor @NonNull @Initialized SortedSet<@UnknownKeyFor @NonNull @Initialized Method> collidingMethods;

        private MultipleDefinitions() {
        }
    }

    private static class TypeMismatch {
        private @UnknownKeyFor @NonNull @Initialized String propertyName;
        private @UnknownKeyFor @NonNull @Initialized Type getterPropertyType;
        private @UnknownKeyFor @NonNull @Initialized Type setterPropertyType;

        private TypeMismatch() {
        }
    }

    static class Registration<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> {
        private final @UnknownKeyFor @NonNull @Initialized Class<T> proxyClass;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> propertyDescriptors;

        public Registration(@UnknownKeyFor @NonNull @Initialized Class<T> proxyClass, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> beanInfo) {
            this.proxyClass = proxyClass;
            this.propertyDescriptors = beanInfo;
        }

        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        @UnknownKeyFor @NonNull @Initialized Class<T> getProxyClass() {
            return this.proxyClass;
        }
    }

    public static class Builder {
        private final @UnknownKeyFor @NonNull @Initialized String defaultAppName = PipelineOptionsFactory.access$100();
        private final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args;
        private final @UnknownKeyFor @NonNull @Initialized boolean validation;
        private final @UnknownKeyFor @NonNull @Initialized boolean strictParsing;
        private final @UnknownKeyFor @NonNull @Initialized boolean isCli;

        private Builder() {
            this(new String[0], false, true, false);
        }

        private Builder(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args, @UnknownKeyFor @NonNull @Initialized boolean validation, @UnknownKeyFor @NonNull @Initialized boolean strictParsing, @UnknownKeyFor @NonNull @Initialized boolean isCli) {
            this.args = args;
            this.validation = validation;
            this.strictParsing = strictParsing;
            this.isCli = isCli;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder fromArgs(String ... args) {
            Preconditions.checkNotNull((Object)args, (Object)"Arguments should not be null.");
            return new Builder(args, this.validation, this.strictParsing, true);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withValidation() {
            return new Builder(this.args, true, this.strictParsing, this.isCli);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withoutStrictParsing() {
            return new Builder(this.args, this.validation, false, this.isCli);
        }

        public @UnknownKeyFor @NonNull @Initialized PipelineOptions create() {
            return this.as(PipelineOptions.class);
        }

        public <T extends PipelineOptions> T as(@UnknownKeyFor @NonNull @Initialized Class<T> klass) {
            ProxyInvocationHandler handler;
            ApplicationNameOptions t;
            ApplicationNameOptions appNameOptions;
            Map initialOptions = Maps.newHashMap();
            if (this.args != null) {
                ListMultimap options = PipelineOptionsFactory.parseCommandLine(this.args, this.strictParsing);
                LOG.debug("Provided Arguments: {}", (Object)options);
                PipelineOptionsFactory.printHelpUsageAndExitIfNeeded((ListMultimap<String, String>)options, System.out, true);
                initialOptions = PipelineOptionsFactory.parseObjects(klass, (ListMultimap<String, String>)options, this.strictParsing);
            }
            if ((appNameOptions = (t = (handler = new ProxyInvocationHandler(initialOptions)).as(klass)).as(ApplicationNameOptions.class)).getAppName() == null) {
                appNameOptions.setAppName(this.defaultAppName);
            }
            t.getOptionsId();
            if (this.validation) {
                if (this.isCli) {
                    PipelineOptionsValidator.validateCli(klass, t);
                } else {
                    PipelineOptionsValidator.validate(klass, t);
                }
            }
            return (T)t;
        }
    }
}

