/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.readonly;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrappedGraphQuery;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.readonly.ReadOnlyEdge;
import com.tinkerpop.blueprints.util.wrappers.readonly.ReadOnlyEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.readonly.ReadOnlyVertex;
import com.tinkerpop.blueprints.util.wrappers.readonly.ReadOnlyVertexIterable;

public class ReadOnlyGraph<T extends Graph>
implements Graph,
WrapperGraph<T> {
    protected final T baseGraph;
    private final Features features;

    public ReadOnlyGraph(T baseGraph) {
        this.baseGraph = baseGraph;
        this.features = this.baseGraph.getFeatures().copyFeatures();
        this.features.isWrapper = true;
    }

    @Override
    public void removeVertex(Vertex vertex) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex vertex = this.baseGraph.getVertex(id);
        if (null == vertex) {
            return null;
        }
        return new ReadOnlyVertex(vertex);
    }

    @Override
    public void removeEdge(Edge edge) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new ReadOnlyEdgeIterable(this.baseGraph.getEdges());
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        return new ReadOnlyEdgeIterable(this.baseGraph.getEdges(key, value));
    }

    @Override
    public Edge getEdge(Object id) {
        Edge edge = this.baseGraph.getEdge(id);
        if (null == edge) {
            return null;
        }
        return new ReadOnlyEdge(edge);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new ReadOnlyVertexIterable(this.baseGraph.getVertices());
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        return new ReadOnlyVertexIterable(this.baseGraph.getVertices(key, value));
    }

    @Override
    public Vertex addVertex(Object id) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public void shutdown() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    public String toString() {
        return StringFactory.graphString(this, this.baseGraph.toString());
    }

    @Override
    public T getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public GraphQuery query() {
        return new WrappedGraphQuery(this.baseGraph.query()){

            @Override
            public Iterable<Edge> edges() {
                return new ReadOnlyEdgeIterable(this.query.edges());
            }

            @Override
            public Iterable<Vertex> vertices() {
                return new ReadOnlyVertexIterable(this.query.vertices());
            }
        };
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }
}

