/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.io;

import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.beam.sdk.extensions.avro.io.DynamicAvroDestinations;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AvroSink<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
extends FileBasedSink<UserT, DestinationT, OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized boolean genericRecords;
    private final @UnknownKeyFor @NonNull @Initialized int syncInterval;

    AvroSink(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> outputPrefix, @UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<UserT, DestinationT, OutputT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized boolean genericRecords, @UnknownKeyFor @NonNull @Initialized int syncInterval) {
        super(outputPrefix, dynamicDestinations, Compression.UNCOMPRESSED);
        this.genericRecords = genericRecords;
        this.syncInterval = syncInterval;
    }

    public @UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<UserT, DestinationT, OutputT> getDynamicDestinations() {
        return (DynamicAvroDestinations)super.getDynamicDestinations();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized FileBasedSink.WriteOperation<DestinationT, OutputT> createWriteOperation() {
        return new AvroWriteOperation(this, this.genericRecords, this.syncInterval);
    }

    private static class AvroWriter<@UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
    extends FileBasedSink.Writer<DestinationT, OutputT> {
        private @Nullable @UnknownKeyFor @Initialized DataFileWriter<OutputT> dataFileWriter;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> dynamicDestinations;
        private final @UnknownKeyFor @NonNull @Initialized boolean genericRecords;
        private final @UnknownKeyFor @NonNull @Initialized int syncInterval;

        public AvroWriter(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.WriteOperation<DestinationT, OutputT> writeOperation, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized boolean genericRecords, @UnknownKeyFor @NonNull @Initialized int syncInterval) {
            super(writeOperation, "application/octet-stream");
            this.dynamicDestinations = dynamicDestinations;
            this.genericRecords = genericRecords;
            this.syncInterval = syncInterval;
        }

        protected void prepareWrite(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Object destination = this.getDestination();
            CodecFactory codec = this.dynamicDestinations.getCodec(destination);
            Schema schema = this.dynamicDestinations.getSchema(destination);
            Map<String, Object> metadata = this.dynamicDestinations.getMetadata(destination);
            DatumWriterFactory<OutputT> datumWriterFactory = this.dynamicDestinations.getDatumWriterFactory(destination);
            Object datumWriter = datumWriterFactory == null ? (this.genericRecords ? new GenericDatumWriter(schema) : new ReflectDatumWriter(schema)) : datumWriterFactory.apply(schema);
            this.dataFileWriter = new DataFileWriter((DatumWriter)datumWriter).setCodec(codec);
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                Object v = entry.getValue();
                if (v instanceof String) {
                    this.dataFileWriter.setMeta(entry.getKey(), (String)v);
                    continue;
                }
                if (v instanceof Long) {
                    this.dataFileWriter.setMeta(entry.getKey(), ((Long)v).longValue());
                    continue;
                }
                if (v instanceof byte[]) {
                    this.dataFileWriter.setMeta(entry.getKey(), (byte[])v);
                    continue;
                }
                throw new IllegalStateException("Metadata value type must be one of String, Long, or byte[]. Found " + v.getClass().getSimpleName());
            }
            this.dataFileWriter.setSyncInterval(this.syncInterval);
            this.dataFileWriter.create(schema, Channels.newOutputStream(channel));
        }

        public void write(OutputT value) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.dataFileWriter.append(value);
        }

        protected void finishWrite() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.dataFileWriter.flush();
        }
    }

    private static class AvroWriteOperation<@UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
    extends FileBasedSink.WriteOperation<DestinationT, OutputT> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> dynamicDestinations;
        private final @UnknownKeyFor @NonNull @Initialized boolean genericRecords;
        private final @UnknownKeyFor @NonNull @Initialized int syncInterval;

        private AvroWriteOperation(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AvroSink<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT, OutputT> sink, @UnknownKeyFor @NonNull @Initialized boolean genericRecords, @UnknownKeyFor @NonNull @Initialized int syncInterval) {
            super(sink);
            this.dynamicDestinations = sink.getDynamicDestinations();
            this.genericRecords = genericRecords;
            this.syncInterval = syncInterval;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.Writer<DestinationT, OutputT> createWriter() throws @UnknownKeyFor @NonNull @Initialized Exception {
            return new AvroWriter<DestinationT, OutputT>(this, this.dynamicDestinations, this.genericRecords, this.syncInterval);
        }
    }

    @FunctionalInterface
    public static interface DatumWriterFactory<@UnknownKeyFor T>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized DatumWriter<T> apply(@UnknownKeyFor @NonNull @Initialized Schema var1);
    }
}

