/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.spark.translation.SparkInputDataProcessor;
import org.apache.beam.runners.spark.translation.SparkProcessContext;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import scala.Tuple2;

class BoundedSparkInputDataProcessor<@UnknownKeyFor FnInputT, @UnknownKeyFor FnOutputT>
implements SparkInputDataProcessor<FnInputT, FnOutputT, Tuple2<TupleTag<?>, WindowedValue<?>>> {
    private final @UnknownKeyFor @NonNull @Initialized BoundedDoFnOutputManager outputManager = new BoundedDoFnOutputManager();

    BoundedSparkInputDataProcessor() {
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager getOutputManager() {
        return this.outputManager;
    }

    @Override
    public <K> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> createOutputIterator(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> input, @UnknownKeyFor @NonNull @Initialized SparkProcessContext<K, FnInputT, FnOutputT> ctx) {
        return new BoundedInOutIterator(input, ctx);
    }

    private class BoundedInOutIterator<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends AbstractIterator<Tuple2<TupleTag<?>, WindowedValue<?>>> {
        private final @UnknownKeyFor @NonNull @Initialized SparkProcessContext<K, InputT, OutputT> ctx;
        private final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> inputIterator;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> outputIterator;
        private final @UnknownKeyFor @NonNull @Initialized ExecutorService executorService;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> outputProducerTask = null;
        private volatile @MonotonicNonNull @UnknownKeyFor @Initialized RuntimeException inputConsumeFailure = null;

        BoundedInOutIterator(@UnknownKeyFor @NonNull @Initialized Iterator<WindowedValue<InputT>> iterator, SparkProcessContext<K, InputT, OutputT> ctx) {
            this.inputIterator = iterator;
            this.ctx = ctx;
            this.outputIterator = BoundedSparkInputDataProcessor.this.outputManager.iterator();
            this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("bounded-in/out-iterator-" + ctx.getStepName() + "-%d").setDaemon(true).build());
        }

        protected /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> computeNext() {
            if (this.outputProducerTask == null) {
                this.outputProducerTask = this.startOutputProducerTask();
            }
            boolean hasNext = this.outputIterator.hasNext();
            if (this.inputConsumeFailure != null) {
                this.executorService.shutdown();
                throw this.inputConsumeFailure;
            }
            if (hasNext) {
                return this.outputIterator.next();
            }
            this.executorService.shutdown();
            return (Tuple2)this.endOfData();
        }

        private void fireTimer(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
            StateNamespace namespace = timer.getNamespace();
            Preconditions.checkArgument((boolean)(namespace instanceof StateNamespaces.WindowNamespace));
            BoundedWindow window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
            this.ctx.getDoFnRunner().onTimer(timer.getTimerId(), timer.getTimerFamilyId(), this.ctx.getKey(), window, timer.getTimestamp(), timer.getOutputTimestamp(), timer.getDomain());
        }

        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> startOutputProducerTask() {
            return this.executorService.submit(() -> {
                try {
                    this.ctx.getDoFnRunner().startBundle();
                    while (true) {
                        if (this.inputIterator.hasNext()) {
                            WindowedValue<InputT> next = this.inputIterator.next();
                            this.ctx.getDoFnRunner().processElement(next);
                            continue;
                        }
                        if (!this.ctx.getTimerDataIterator().hasNext()) break;
                        this.fireTimer(this.ctx.getTimerDataIterator().next());
                    }
                    this.ctx.getDoFnRunner().finishBundle();
                    DoFnInvokers.invokerFor(this.ctx.getDoFn()).invokeTeardown();
                    BoundedSparkInputDataProcessor.this.outputManager.stop();
                }
                catch (RuntimeException ex) {
                    this.inputConsumeFailure = ex;
                    DoFnInvokers.invokerFor(this.ctx.getDoFn()).invokeTeardown();
                    BoundedSparkInputDataProcessor.this.outputManager.stop();
                }
            });
        }
    }

    private static class BoundedDoFnOutputManager
    implements DoFnRunners.OutputManager,
    Iterable<Tuple2<TupleTag<?>, WindowedValue<?>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized LinkedBlockingQueue<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> queue = new LinkedBlockingQueue(500);
        private volatile @UnknownKeyFor @NonNull @Initialized boolean stopped = false;

        private BoundedDoFnOutputManager() {
        }

        public void stop() {
            this.stopped = true;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> iterator() {
            return new Iterator<Tuple2<TupleTag<?>, WindowedValue<?>>>(){
                private /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @Nullable @UnknownKeyFor @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> next = null;

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                    try {
                        while (!(this.next != null || stopped && queue.isEmpty())) {
                            this.next = (Tuple2)queue.poll(1000L, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException(e);
                    }
                    return this.next != null;
                }

                @Override
                public /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Tuple2<TupleTag<?>, WindowedValue<?>> value = this.next;
                    this.next = null;
                    return value;
                }
            };
        }

        public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
            try {
                Preconditions.checkState((!this.stopped ? 1 : 0) != 0, (Object)"Output called on already stopped manager");
                this.queue.put(new Tuple2(tag, output));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }
    }
}

