/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.beam.runners.spark.structuredstreaming.translation.EvaluationContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.CoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Function1;

@Internal
public interface SideInputValues<@UnknownKeyFor T>
extends Serializable,
KryoSerializable {
    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<T> get(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

    public static <T> @UnknownKeyFor @NonNull @Initialized Loader<T> loader(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCol) {
        WindowFn fn = pCol.getWindowingStrategy().getWindowFn();
        return fn instanceof GlobalWindows ? ds -> new Global(pCol.getName(), pCol.getCoder(), ds) : ds -> new ByWindow(pCol.getName(), WindowedValue.getFullCoder((Coder)pCol.getCoder(), (Coder)fn.windowCoder()), ds);
    }

    public static abstract class BaseSideInputValues<@UnknownKeyFor BinaryT, @UnknownKeyFor ValuesT, @UnknownKeyFor T>
    implements SideInputValues<T> {
        private @UnknownKeyFor @NonNull @Initialized Coder<BinaryT> coder;
        @Nullable
        private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized [] @UnknownKeyFor @NonNull @Initialized [] binaryValues;
        private transient @MonotonicNonNull ValuesT values = null;

        private BaseSideInputValues(@UnknownKeyFor @NonNull @Initialized Coder<BinaryT> coder, @Nullable @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized [] @UnknownKeyFor @NonNull @Initialized [] binary) {
            this.coder = coder;
            this.binaryValues = binary;
        }

        abstract ValuesT deserialize(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] var1, @UnknownKeyFor @NonNull @Initialized Coder<BinaryT> var2);

        final ValuesT getValues() {
            if (this.values == null) {
                this.values = this.deserialize((byte[][])org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.binaryValues), this.coder);
            }
            return this.values;
        }

        public void write(@UnknownKeyFor @NonNull @Initialized Kryo kryo, @UnknownKeyFor @NonNull @Initialized Output output) {
            kryo.writeClassAndObject(output, this.coder);
            kryo.writeObject(output, org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.binaryValues));
        }

        public void read(@UnknownKeyFor @NonNull @Initialized Kryo kryo, @UnknownKeyFor @NonNull @Initialized Input input) {
            this.coder = (Coder)kryo.readClassAndObject(input);
            this.values = this.deserialize((byte[][])org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)((byte[][])kryo.readObject(input, byte[][].class))), this.coder);
        }
    }

    public static class ByWindow<@UnknownKeyFor T>
    extends BaseSideInputValues<WindowedValue<T>, Map<BoundedWindow, List<T>>, T> {
        @VisibleForTesting
        ByWindow(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> coder, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> ds) {
            super(coder, EvaluationContext.collect(name, ByWindow.binaryDataset(ds, coder)));
        }

        @Override
        @Nullable
        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<T> get(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return (List)((Map)this.getValues()).get(window);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized List<T>> deserialize(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] binaryValues, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> coder) {
            HashMap<BoundedWindow, List<T>> values = new HashMap<BoundedWindow, List<T>>();
            for (byte[] binaryValue : binaryValues) {
                WindowedValue<T> value = CoderHelpers.fromByteArray(binaryValue, coder);
                for (BoundedWindow window : value.getWindows()) {
                    List list = values.computeIfAbsent(window, w -> new ArrayList());
                    list.add(value.getValue());
                }
            }
            return values;
        }

        private static <T> @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> binaryDataset(@UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> ds, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> coder) {
            return ds.map(ByWindow.bytes(coder), Encoders.BINARY());
        }

        private static <T> @UnknownKeyFor @NonNull @Initialized Function1<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> bytes(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> coder) {
            return ScalaInterop.fun1(t -> CoderHelpers.toByteArray(t, coder));
        }
    }

    public static class Global<@UnknownKeyFor T>
    extends BaseSideInputValues<T, List<T>, T> {
        @VisibleForTesting
        Global(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> data) {
            super(coder, EvaluationContext.collect(name, Global.binaryDataset(data, coder)));
        }

        @Override
        @Nullable
        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<T> get(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            Preconditions.checkArgument((boolean)(window instanceof GlobalWindow), (Object)"Expected GlobalWindow");
            return (List)this.getValues();
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized List<T> deserialize(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] binaryValues, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            ArrayList<T> values = new ArrayList<T>(binaryValues.length);
            for (byte[] binaryValue : binaryValues) {
                values.add(CoderHelpers.fromByteArray(binaryValue, coder));
            }
            return values;
        }

        private static <T> @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> binaryDataset(@UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> ds, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return ds.map(Global.bytes(coder), Encoders.BINARY());
        }

        private static <T> @UnknownKeyFor @NonNull @Initialized Function1<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> bytes(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return ScalaInterop.fun1(t -> CoderHelpers.toByteArray(t.getValue(), coder));
        }
    }

    public static interface Loader<@UnknownKeyFor T>
    extends Function<Dataset<WindowedValue<T>>, SideInputValues<T>> {
    }
}

