/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.delete;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.pipeline.transforms.delete.DeleteKeyField;

public class DeleteLookupField {
    @HopMetadataProperty(key="key", injectionGroupDescription="Delete.Injection.Fields", injectionKeyDescription="Delete.Injection.Field")
    private List<DeleteKeyField> fields;
    @HopMetadataProperty(key="schema", injectionKeyDescription="Delete.Injection.SchemaName.Field")
    private String schemaName;
    @HopMetadataProperty(key="table", injectionKeyDescription="Delete.Injection.TableName.Field")
    private String tableName;

    public DeleteLookupField() {
        this.fields = new ArrayList<DeleteKeyField>();
    }

    public DeleteLookupField(DeleteLookupField obj) {
        this.schemaName = obj.schemaName;
        this.tableName = obj.tableName;
        this.fields = new ArrayList<DeleteKeyField>();
        for (DeleteKeyField field : obj.fields) {
            this.fields.add(new DeleteKeyField(field));
        }
    }

    public DeleteLookupField(String schemaName, String tableName, List<DeleteKeyField> fields) {
        this.fields = fields;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public List<DeleteKeyField> getFields() {
        return this.fields;
    }

    public void setFields(List<DeleteKeyField> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteLookupField that = (DeleteLookupField)o;
        return this.fields.equals(that.fields) && Objects.equals(this.schemaName, that.schemaName) && this.tableName.equals(that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.schemaName, this.tableName);
    }
}

