/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AdminACLsManager {
    private static final Logger LOG = LoggerFactory.getLogger(AdminACLsManager.class);
    private final UserGroupInformation owner;
    private final AccessControlList adminAcl;
    private final boolean aclsEnabled;

    public AdminACLsManager(Configuration conf) {
        this.adminAcl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        try {
            this.owner = UserGroupInformation.getCurrentUser();
            this.adminAcl.addUser(this.owner.getShortUserName());
        }
        catch (IOException e) {
            LOG.warn("Could not add current user to admin:" + e);
            throw new YarnRuntimeException(e);
        }
        this.aclsEnabled = conf.getBoolean("yarn.acl.enable", false);
    }

    public UserGroupInformation getOwner() {
        return this.owner;
    }

    public boolean areACLsEnabled() {
        return this.aclsEnabled;
    }

    public boolean isAdmin(UserGroupInformation callerUGI) {
        return this.adminAcl.isUserAllowed(callerUGI);
    }
}

